/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.audit;

import com.bxm.adsmanager.model.vo.audit.IndustryAuditVo;
import com.bxm.adsmanager.service.audit.IndustryService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/audit"})
public class IndustryAuditController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndustryAuditController.class);
    @Autowired
    IndustryService industryService;

    @RequestMapping(value={"/industry/add"}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="code") String code) {
        try {
            String userName = this.getUser(request, response).getUsername();
            this.industryService.add(code, userName);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u5ba1\u6838\u6807\u7b7e\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/industry/delete"}, produces={"application/json"})
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") Long id) {
        try {
            String userName = this.getUser(request, response).getUsername();
            this.industryService.delete(id, userName);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5ba1\u6838\u6807\u7b7e\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5220\u9664\u5ba1\u6838\u6807\u7b7e\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/industry/getList"}, produces={"application/json"})
    public ResultModel<List<IndustryAuditVo>> getList(HttpServletRequest request, HttpServletResponse response) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.industryService.getList());
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u6807\u7b7e\u5ba1\u6838\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u6807\u7b7e\u5ba1\u6838\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }

    @RequestMapping(value={"/industry/getPageList"}, produces={"application/json"})
    public ResultModel<PageInfo<IndustryAuditVo>> getPageList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, HttpServletRequest request, HttpServletResponse response) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.industryService.getPageList(pageNum, pageSize));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u6807\u7b7e\u5ba1\u6838\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u6807\u7b7e\u5ba1\u6838\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }
}

