/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.audit;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dto.LandingPagePlanSearchDto;
import com.bxm.adsmanager.service.adkeeper.LandingPageService;
import com.bxm.adsmanager.service.audit.LandingPageAuditService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/audit/landingPage"})
public class LandingPageAuditController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(LandingPageAuditController.class);
    @Autowired
    private LandingPageService landingPageService;
    @Autowired
    private LandingPageAuditService landingPageAuditService;

    @GetMapping(value={"/list"})
    public ResultModel getList(LandingPagePlanSearchDto dto) {
        PageInfo list = this.landingPageService.list(dto);
        return ResultModelFactory.SUCCESS((Serializable)list);
    }

    @LogBefore(operType="/audit/landingPage/updateAudit", keyName="\u843d\u5730\u9875ab\u8ba1\u5212\u5ba1\u6838")
    @PostMapping(value={"/updateAudit"})
    public ResultModel<Boolean> landingPageAudit(@RequestParam(value="id") Long id, @RequestParam(value="auditStatus") Short auditStatus, @RequestParam(value="refuseReason") String refuseReason) {
        try {
            this.landingPageAuditService.landingPageAudit(id, auditStatus, refuseReason);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }
}

