/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.audit;

import com.bxm.adsmanager.model.vo.audit.RefuseConfigVo;
import com.bxm.adsmanager.service.audit.RefuseService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/audit"})
public class RefuseController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefuseController.class);
    @Autowired
    RefuseService refuseService;

    @RequestMapping(value={"/refuse/add"}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="reason") String reason, @RequestParam(value="type") Short type) {
        try {
            String userName = this.getUser(request, response).getUsername();
            this.refuseService.add(reason, type, userName);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u62d2\u7edd\u539f\u56e0\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/refuse/update"}, produces={"application/json"})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="reason") String reason, @RequestParam(value="id") Long id) {
        try {
            String userName = this.getUser(request, response).getUsername();
            this.refuseService.update(reason, id, userName);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u62d2\u7edd\u539f\u56e0\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/refuse/updateStatus"}, produces={"application/json"})
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") Long id, @RequestParam(value="status") Short status) {
        try {
            String userName = this.getUser(request, response).getUsername();
            this.refuseService.updateStatus(id, status, userName);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u62d2\u7edd\u539f\u56e0\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/refuse/getList"}, produces={"application/json"})
    public ResultModel<PageInfo<RefuseConfigVo>> getList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, @RequestParam(value="type", required=false) String type, @RequestParam(value="status", required=false) String status) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.refuseService.getList(type, status, pageNum, pageSize));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u62d2\u7edd\u539f\u56e0\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u62d2\u7edd\u539f\u56e0\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }
}

