/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.base;

import com.bxm.acl.facade.model.UserVo;
import com.bxm.adsmanager.integration.logs.LogsIntegration;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.utils.IPUtils;
import com.bxm.log.facade.dao.LogModel;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseController.class);
    private static final ThreadPoolExecutor SAVE_LOG_POOL = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("Save Log Pool"));
    public static final String SESSION_USER_NAME = "user";
    @Autowired
    private LogsIntegration logsIntegration;

    public User getUser(HttpServletRequest request, HttpServletResponse response) {
        User user = new User();
        try {
            UserVo userVo = (UserVo)request.getAttribute(SESSION_USER_NAME);
            if (userVo != null) {
                BeanUtils.copyProperties((Object)userVo, (Object)user);
                if (null != userVo.getId()) {
                    user.setId(String.valueOf(userVo.getId()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        user.setIp(IPUtils.getIp((HttpServletRequest)request));
        return user;
    }

    public void addLogs(User user, String content, String adticketId) {
        try {
            String userAccount = "-";
            if (user != null) {
                userAccount = user.getUserAllRole();
            }
            LogModel logModel = new LogModel.Builder().userName(userAccount).userAccount(user.getUsername()).parentAccount(userAccount).content(content).adticketId(adticketId).ip(user.getIp()).build();
            SAVE_LOG_POOL.execute(() -> this.logsIntegration.add(logModel));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addNewLogs(User user, String logInfo, String adticketId) {
        try {
            String userAccount = "-";
            if (user != null) {
                userAccount = user.getUserAllRole();
            }
            LogModel logModel = new LogModel.Builder().userName(userAccount).userAccount(user.getUsername()).parentAccount(userAccount).logInfo(logInfo).adticketId(adticketId).ip(user.getIp()).build();
            this.logsIntegration.add(logModel);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

