/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.dictionary;

import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.common.DictionaryGroup;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.util.dto.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dictionary"})
public class DictionaryController {
    @Autowired
    private DictionariesService dictionariesService;

    @RequestMapping(value={"/findDictionaryGroup"}, method={RequestMethod.GET})
    public ResultModel findDictionaryGroup(@RequestParam(value="keyword") String keyword, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="20") Integer pageSize) {
        return this.dictionariesService.findDictionaryGroup(keyword, pageNum, pageSize);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel add(DictionaryGroup dictionaryGroup) {
        return this.dictionariesService.insertTypeGroup(dictionaryGroup);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public ResultModel delete(@RequestParam(value="id") String id) {
        return this.dictionariesService.deleteTypeGroup(id);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResultModel update(DictionaryGroup dictionaryGroup) {
        return this.dictionariesService.updateTypeGroup(dictionaryGroup);
    }

    @RequestMapping(value={"/findDictionary"}, method={RequestMethod.GET})
    public ResultModel findDictionary(@RequestParam(value="typeGroupId") String typeGroupId, @RequestParam(value="keyword") String keyword, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="20") Integer pageSize) {
        return this.dictionariesService.findDictionary(typeGroupId, pageNum, pageSize, keyword);
    }

    @RequestMapping(value={"/findDictionaryGroupNoPage"}, method={RequestMethod.GET})
    public ResultModel findDictionary(@RequestParam(value="typeGroupCode") String typeGroupCode) {
        return this.dictionariesService.findDictionaryNoPage(typeGroupCode);
    }

    @RequestMapping(value={"/addDictionary"}, method={RequestMethod.POST})
    public ResultModel addDictionary(Dictionaries dictionaries) {
        return this.dictionariesService.addDictionary(dictionaries);
    }

    @RequestMapping(value={"/updateDictionary"}, method={RequestMethod.POST})
    public ResultModel updateDictionary(Dictionaries dictionaries) {
        return this.dictionariesService.updateDictionary(dictionaries);
    }

    @RequestMapping(value={"/deleteDictionary"}, method={RequestMethod.GET})
    public ResultModel deleteDictionary(@RequestParam(value="id") String id) {
        return this.dictionariesService.deleteDictionary(id);
    }
}

