/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.explore;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.explore.TicketExploreDto;
import com.bxm.adsmanager.model.vo.explore.TicketExploreVo;
import com.bxm.adsmanager.service.explore.TicketExploreService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/explore"})
public class TicketExploreController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(TicketExploreController.class);
    @Autowired
    TicketExploreService ticketExploreService;

    @RequestMapping(value={"/add"}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, TicketExploreDto ticketExploreDto) {
        try {
            User user = this.getUser(request, response);
            this.ticketExploreService.add(ticketExploreDto, user.getUsername());
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u52a0\u901f\u63a2\u7d22\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/findById"}, method={RequestMethod.GET})
    public ResultModel<TicketExploreVo> findById(Long ticketId) {
        ResultModel rs = new ResultModel();
        try {
            TicketExploreVo ticketExploreVo = this.ticketExploreService.findById(ticketId);
            rs.setReturnValue((Object)ticketExploreVo);
        }
        catch (Exception e) {
            log.error("\u67e5\u627e\u5e7f\u544a\u5238appu\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc(e.getMessage());
        }
        return rs;
    }

    @RequestMapping(value={"/update"}, produces={"application/json"})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, TicketExploreDto ticketExploreDto) {
        try {
            User user = this.getUser(request, response);
            this.ticketExploreService.update(ticketExploreDto, user.getUsername());
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u52a0\u901f\u63a2\u7d22\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/findOrUpdateConsume"}, method={RequestMethod.GET})
    public ResultModel<String> findConsume(Long id, Integer type) {
        ResultModel rs = new ResultModel();
        try {
            String value = this.ticketExploreService.findConsume(id, type);
            rs.setReturnValue((Object)value);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6d88\u8017\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc(e.getMessage());
        }
        return rs;
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    public ResultModel<String> test(Long id) {
        ResultModel rs = new ResultModel();
        try {
            String value = this.ticketExploreService.push1(id);
            rs.setReturnValue((Object)value);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6d88\u8017\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc(e.getMessage());
        }
        return rs;
    }
}

