/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.integration.adsprod.service.ProdAdvertiserIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.commons.currency.Money;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/advertiser"})
public class AdvertiserTicketController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserTicketController.class);
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private ProdAdvertiserIntegration prodAdvertiserIntegration;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;
    @Autowired
    private ProdPullerIntegration prodPuller;

    @LogBefore(user="advertiser", operType="/advertiser/updateAdTicket", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/updateAdTicket"}, method={RequestMethod.POST})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="id") Long id, @RequestParam(required=true, name="status") Short status) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            AdTicket adTicket = new AdTicket();
            adTicket.setId(id);
            adTicket.setStatus(status);
            adTicket.setModifyUser("\u5e7f\u544a\u4e3b\u66f4\u65b0");
            LOGGER.info("advertiser\u8bf7\u6c42\u66f4\u65b0\u5e7f\u544a\u5238\u72b6\u6001:id=" + id + ",status=" + status);
            Integer result = this.adTicketService.advertiserUpdateStatus(adTicket);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("advertiser\u66f4\u65b0\u5e7f\u544a\u5238\u72b6\u6001\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return rs;
    }

    @LogBefore(user="advertiser", operType="/advertiser/updateDailyBudget", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/updateDailyBudget"}, method={RequestMethod.POST})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="id") Long id, @RequestParam(required=true, name="dailyBudget") Double dailyBudget) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            LOGGER.info("advertiser\u8bf7\u6c42\u66f4\u65b0\u5e7f\u544a\u5238\u65e5\u9884\u7b97:id=" + id + ",dailyBudget=" + dailyBudget);
            Integer result = this.adTicketService.updateDailyBudget(id, dailyBudget);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("advertiser\u8bf7\u6c42\u66f4\u65b0\u5e7f\u544a\u5238\u65e5\u9884\u7b97" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return rs;
    }

    @LogBefore(user="advertiser", operType="/advertiser/getAdvertiserBalance", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/getAdvertiserBalance"}, method={RequestMethod.GET})
    public ResultModel getAdvertiserBalance(@RequestParam(required=true, name="id") Long id) {
        ResultModel rs = new ResultModel();
        try {
            Money money = Money.ofLi((long)this.prodPuller.getAdvertiserBalance(id));
            rs.setReturnValue((Object)money.getYuan());
        }
        catch (Exception e) {
            LOGGER.error("advertiser\u83b7\u53d6\u5e7f\u544a\u4e3b\u4f59\u989d\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return rs;
    }

    @LogBefore(user="advertiser", operType="/advertiser/reUpdateAdTicket", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/reUpdateAdTicket"}, method={RequestMethod.POST})
    public ResultModel reUpdate(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="id") Long id, @RequestParam(required=true, name="status") Short status) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            AdTicket adTicket = new AdTicket();
            adTicket.setId(id);
            adTicket.setStatus(status);
            adTicket.setModifyUser("\u5e7f\u544a\u4e3b\u66f4\u65b0");
            LOGGER.info("advertiser\u8bf7\u6c42\u91cd\u65b0\u63d0\u4ea4\u5ba1\u6838:id=" + id + ",status=" + status);
            Integer result = this.adTicketService.advertiserReUpdateStatus(adTicket);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("advertiser\u66f4\u65b0\u5e7f\u544a\u5238\u72b6\u6001\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return rs;
    }

    @RequestMapping(value={"/findBalanceByIds"}, method={RequestMethod.POST})
    public ResultModel findBalanceByIds(@RequestParam(value="advertiserIds") List<Integer> advertiserIds) {
        ResultModel rs = new ResultModel();
        try {
            Map map = this.prodPuller.findBalanceByIds(advertiserIds);
            rs.setReturnValue((Object)map);
        }
        catch (Exception e) {
            LOGGER.error("advertiser\u83b7\u53d6\u5e7f\u544a\u4e3b\u53ca\u5b50\u8d26\u53f7\u4f59\u989d\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return rs;
    }

    @RequestMapping(value={"/findBalanceByIdsByPost"}, method={RequestMethod.POST})
    public ResultModel findBalanceByIdsByPost(@RequestBody List<Integer> advertiserIds) {
        ResultModel rs = new ResultModel();
        try {
            Map map = this.prodPuller.findBalanceByIds(advertiserIds);
            rs.setReturnValue((Object)map);
        }
        catch (Exception e) {
            LOGGER.error("advertiser\u83b7\u53d6\u5e7f\u544a\u4e3b\u53ca\u5b50\u8d26\u53f7\u4f59\u989d\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL();
        }
        return rs;
    }
}

