/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.facade.model.video.VideoAssetDto;
import com.bxm.adsmanager.facade.model.video.VideoAssetVo;
import com.bxm.adsmanager.service.audit.VideoAssetService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/advertiser"})
public class AdvertiserVideoAssetController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserVideoAssetController.class);
    @Autowired
    VideoAssetService videoAssetService;

    @LogBefore(operType="/advertiser/videoAsset/saveOrUpdate", keyName="\u65e5\u5fd7\u6253\u5370\u6d4b\u8bd5")
    @RequestMapping(value={"/videoAsset/saveOrUpdate"}, produces={"application/json"})
    public ResultModel saveOrUpdate(@RequestBody VideoAssetDto videoAssetDto) {
        try {
            this.videoAssetService.add(videoAssetDto);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u6216\u8005\u4fee\u6539\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/videoAsset/updateStatus"}, produces={"application/json"})
    public ResultModel updateStatus(@RequestParam(value="status", required=true) Short status, @RequestParam(value="id", required=true) Long id, @RequestParam(value="userName", required=true) String userName) {
        try {
            this.videoAssetService.updateStatus(id, status, userName);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u72b6\u6001\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/videoAsset/getList"}, produces={"application/json"})
    public ResultModel<PageInfo<VideoAssetVo>> getList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, @RequestParam(value="keywords", required=false) String keywords, @RequestBody List<Long> advertiserIds) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.videoAssetService.getListByAdvertiser(keywords, pageNum, pageSize, advertiserIds));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }

    @RequestMapping(value={"/videoAsset/getVideoAsset"}, produces={"application/json"})
    public ResultModel<VideoAssetVo> getVideoAsset(@RequestParam(value="id", required=true) Long id, @RequestParam(value="advertiserId", required=true) Long advertiserId) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.videoAssetService.getVideoAssetVo(id, null));
            return resultModel;
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u72b6\u6001\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }
}

