/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.facade;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.service.datapark.DataparkIncomeService;
import com.bxm.util.StringUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IncomeController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncomeController.class);
    @Autowired
    private DataparkIncomeService dataparkIncomeService;

    @RequestMapping(value={"/app/income/update"})
    public void dealAppCash(@RequestParam(name="datetime") String datetime) {
        try {
            this.dataparkIncomeService.dealAppCash(datetime);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/ticket/income/update"})
    public void dealAppCash(@RequestParam(name="datetime") String datetime, @RequestParam(name="certificateids") String certificateids) {
        try {
            if (StringUtil.isEmpty((CharSequence)certificateids) || StringUtil.isEmpty((CharSequence)datetime)) {
                return;
            }
            this.dataparkIncomeService.dealTicketIncome(datetime, JSON.parseArray((String)certificateids, Long.class));
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

