/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsTemplateContentMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.PanguCreativeMapperExt;
import com.bxm.adsmanager.facade.service.PanguCreativeFacadeService;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateContentExample;
import com.bxm.adsmanager.model.dao.adkeeper.PanguCreative;
import com.bxm.adsmanager.model.dao.adkeeper.PanguCreativeExample;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.PanguCreativeDTO;
import com.bxm.adsmanager.service.adkeeper.PanguCreativeService;
import com.bxm.adsmanager.utils.GifDecoder;
import com.bxm.util.AliOSSUtil;
import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class PanguCreativeFacadeServiceImpl
implements PanguCreativeFacadeService {
    @Autowired
    private PanguCreativeService panguCreativeService;
    @Autowired
    private PanguCreativeMapperExt panguCreativeMapperExt;
    @Autowired
    private AdAssetsTemplateContentMapper adAssetsTemplateContentMapper;
    private String bucketName = "bxm-guide";
    private String fileHost = "https://buyimg.bianxianmao.com/";
    private String accessKeyId = "LTAIdRl4etA0hXJt";
    private String secret = "oVazl7iJufs7QfGJBuGWoIkJTjIjUa";

    public String upload(MultipartFile file) throws Exception {
        int height;
        int width;
        Object sourceImg;
        String suffix;
        String url;
        if (file == null) {
            return null;
        }
        String md5 = DigestUtils.md5DigestAsHex((byte[])file.getBytes());
        PanguCreativeExample panguCreativeExample = new PanguCreativeExample();
        panguCreativeExample.createCriteria().andMd5EqualTo(md5);
        List creatives = this.panguCreativeMapperExt.selectByExample(panguCreativeExample);
        if (CollectionUtils.isNotEmpty((Collection)creatives)) {
            return ((PanguCreative)creatives.get(0)).getPicture();
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getBytes());){
            url = AliOSSUtil.upload((String)this.accessKeyId, (String)this.secret, (InputStream)inputStream, (String)this.bucketName, (String)this.fileHost, null);
        }
        String fileName = file.getOriginalFilename();
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            fileName = ".jpg";
        }
        if ("gif".equalsIgnoreCase(suffix = fileName.substring(fileName.lastIndexOf(".") + 1))) {
            sourceImg = GifDecoder.read((InputStream)file.getInputStream());
            width = sourceImg.getWidth();
            height = sourceImg.getHeight();
        } else {
            sourceImg = ImageIO.read(file.getInputStream());
            width = ((BufferedImage)sourceImg).getWidth();
            height = ((BufferedImage)sourceImg).getHeight();
        }
        AdAssetsTemplateContentExample adAssetsTemplateContentExample = new AdAssetsTemplateContentExample();
        adAssetsTemplateContentExample.createCriteria().andPictureConstraintsLike(width + "-" + height + "%");
        int assetsTemplateContentCount = this.adAssetsTemplateContentMapper.countByExample(adAssetsTemplateContentExample);
        if (assetsTemplateContentCount == 0) {
            return url;
        }
        PanguCreativeDTO dto = new PanguCreativeDTO();
        PanguCreativeDTO.Creative creative = new PanguCreativeDTO.Creative();
        creative.setFormat(suffix.toUpperCase());
        creative.setPicture(url);
        creative.setMd5(md5);
        creative.setSize(width + "*" + height);
        dto.setCreatives((List)Lists.newArrayList((Object[])new PanguCreativeDTO.Creative[]{creative}));
        User user = new User();
        user.setUsername("facade sync creative");
        this.panguCreativeService.add(user, dto);
        return url;
    }
}

