/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.facade;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.facade.model.precharge.PrechargeCorrectSearchDTO;
import com.bxm.adsmanager.facade.model.precharge.PrechargeDTO;
import com.bxm.adsmanager.facade.service.PrechargeFacadeService;
import com.bxm.adsmanager.service.precharge.PrechargeCorrectService;
import com.bxm.adsmanager.service.precharge.PrechargeDetailService;
import com.bxm.adsmanager.service.precharge.PrechargeService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.bxm.warcar.validate.ValidateException;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PrechargeFacadeServiceImpl
implements PrechargeFacadeService {
    private static final Logger log = LoggerFactory.getLogger(PrechargeFacadeServiceImpl.class);
    @Autowired
    private PrechargeService prechargeService;
    @Autowired
    private PrechargeDetailService prechargeDetailService;
    @Autowired
    private PrechargeCorrectService prechargeCorrectService;

    public ResultModel listPrechargeConfig(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="account") String account, @RequestParam(value="providerKeyword", required=false) String providerKeyword, @RequestParam(value="dateTime", required=false) String dateTime, @RequestParam(value="mjs", required=false) String mjs, @RequestParam(value="bds", required=false) String bds, @RequestParam(value="areaType", required=false, defaultValue="0") Integer areaType) {
        return ResultModelFactory.SUCCESS((Object)this.prechargeService.listPrechargeConfig(pageNum, pageSize, account, providerKeyword, null, dateTime, mjs, bds));
    }

    public ResultModel listRechargeDetail(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime, @RequestParam(value="accountId") Long accountId) {
        return ResultModelFactory.SUCCESS((Object)this.prechargeDetailService.listRechargeDetail(pageNum, pageSize, startTime, endTime, accountId));
    }

    public Boolean rechargeBalance(@RequestParam(value="accountId") Long accountId, @RequestParam(value="amount") BigDecimal amount, @RequestParam(value="datetime") String datetime, @RequestParam(value="currentUser") String currentUser) {
        return this.prechargeService.rechargeBalance(accountId, amount, datetime, currentUser);
    }

    public PageInfo getCorrectRecordList(@RequestBody PrechargeCorrectSearchDTO dto) {
        return this.prechargeCorrectService.getRecordList(dto);
    }

    public Boolean correctAudit(@RequestParam(value="correctId") Long correctId, @RequestParam(value="auditStatus") Byte auditStatus, @RequestParam(value="refuseReason", required=false) String refuseReason, @RequestParam(value="auditUser") String auditUser) {
        return this.prechargeCorrectService.correctAudit(correctId, auditStatus, refuseReason, auditUser);
    }

    public ResultModel<Boolean> updateProviderEndDate(Long accountId, String providers) {
        ResultModel resultModel = new ResultModel();
        try {
            this.prechargeService.updateProviderEndDate(accountId, providers);
            resultModel.setReturnValue((Object)true);
            resultModel.setSuccessed(true);
        }
        catch (BusinessException e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u7cfb\u7edf\u9519\u8bef");
        }
        return resultModel;
    }

    public ResultModel addPrechargeConfig(@RequestBody PrechargeDTO dto) {
        try {
            this.prechargeService.addPrechargeConfig(dto);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAILED500((String)e.getMessage());
        }
        catch (ValidateException e) {
            return ResultModelFactory.FAILED400((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAILED500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    public ResultModel updatePrechargeConfig(@RequestBody PrechargeDTO dto) {
        try {
            this.prechargeService.updatePrechargeConfig(dto);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAILED500((String)e.getMessage());
        }
        catch (ValidateException e) {
            return ResultModelFactory.FAILED400((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAILED500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }
}

