/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.media;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.facade.model.position.PositionUpdateDto;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.media.NewMediaFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.media.AdMedia;
import com.bxm.adsmanager.model.dao.media.AdMediaPosition;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AvilableTicketSearchDto;
import com.bxm.adsmanager.model.dto.position.PositionDirectFlowAssignDto;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.AdTicketAllVo;
import com.bxm.adsmanager.model.vo.media.AdMediaTagVo;
import com.bxm.adsmanager.model.vo.media.ProviderForAdsmanagerVO;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.service.media.MediaService;
import com.bxm.adsmanager.service.mediamanager.PositionTicketWeightService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.adsmanager.utils.WechatMiniAppVerifyFileUploadUtil;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.adsmedia.facade.model.media.MediaAuditVO;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdRO;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.cache.Updater;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MediaController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaController.class);
    @Autowired
    private MediaService mediaService;
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private PositionTicketWeightService positionTicketWeightService;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private NewMediaFacadeIntegration newMediaFacadeIntegration;
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="jedisUpdaterForGateway")
    private Updater updaterForGateway;

    @GetMapping(value={"/getMedia"}, produces={"application/json"})
    public ResultModel<List<AdMedia>> queryMedia(@RequestParam(value="keyword", required=false) String keyword) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.mediaService.queryMedia2(keyword));
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/media"}, produces={"application/json"})
    public ResultModel<PageInfo<ProviderForAdsmanagerVO>> queryMedia(@RequestParam(value="keyword", required=false) String keyword, @RequestParam(value="mjcode", required=false) String mjcode, @RequestParam(value="bdcode", required=false) String bdcode, @RequestParam(value="email", required=false) String email, @RequestParam(value="prepay", required=false) Integer prepay, @RequestParam(value="areaType", required=false) Integer areaType, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        if (null == user) {
            throw new BusinessException("\u672a\u767b\u5f55\uff01");
        }
        return ResultModelFactory.SUCCESS((Serializable)this.mediaService.queryMedia(keyword, mjcode, bdcode, email, prepay, pageNum, pageSize, user, areaType));
    }

    @LogBefore(operType="/media/uploadWechatMiniAppVerify", keyName="\u4e0a\u4f20\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6821\u9a8c\u6587\u4ef6")
    @RequestMapping(value={"/media/uploadWechatMiniAppVerify"}, method={RequestMethod.POST})
    public ResultModel uploadWechatMiniAppVerify(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            HashMap map = WechatMiniAppVerifyFileUploadUtil.upload((HttpServletRequest)request);
            for (Map.Entry entry : map.entrySet()) {
                this.updaterForGateway.hupdate(RedisKeys.getWechatMiniAppVerify(), (String)entry.getKey(), entry.getValue());
            }
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u4e0a\u4f20\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6821\u9a8c\u6587\u4ef6\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u4e0a\u4f20\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6821\u9a8c\u6587\u4ef6\u51fa\u9519");
        }
        return rs;
    }

    @GetMapping(value={"/media/position"}, produces={"application/json"})
    public ResultModel<PageInfo<AdMediaPosition>> queryMediaPosition(@RequestParam(value="appkey") String appkey, @RequestParam(value="putinType", required=false) Byte putinType, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="keywords", required=false) String keywords) {
        return ResultModelFactory.SUCCESS((Serializable)this.mediaService.queryMediaPosition(appkey, putinType, pageNum, pageSize, keywords));
    }

    @GetMapping(value={"/media/position/getUrl"}, produces={"application/json"})
    public ResultModel getPositionUrl(@RequestParam(value="positionId") String positionId) {
        if (StringUtils.isBlank((CharSequence)positionId)) {
            throw new BusinessException("\u8bf7\u5148\u9009\u62e9\u5e7f\u544a\u4f4d");
        }
        return ResultModelFactory.SUCCESS((Serializable)this.newAppEntranceFacadeIntegration.getUrl(positionId));
    }

    @GetMapping(value={"/media/position/tag"}, produces={"application/json"})
    public ResultModel<List<AdMediaTagVo>> queryTagByPositionId(@RequestParam(value="appkey") String appkey, @RequestParam(value="business") String business) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.mediaService.queryTagByPositionId(appkey, business));
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/media/position/getAvailableTicket"}, produces={"application/json"})
    public ResultModel<PageInfo<AdTicketAllVo>> getAvailableTicket(AvilableTicketSearchDto dto) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.positionTicketWeightService.getAvailableTicket(dto));
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/media/code"}, produces={"application/json"})
    public ResultModel<List<Dictionaries>> queryDictionaries(@RequestParam(value="code") String code) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.dictionariesService.findAll(code));
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @LogBefore(operType="/media/tag/delete", keyName="\u5220\u9664\u6807\u7b7e")
    @PostMapping(value={"/media/tag/delete"}, produces={"application/json"})
    public ResultModel<Boolean> deleteTag(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="appkey") String appkey, @RequestParam(value="businessArray") String businessArray, @RequestParam(value="tagArray") String tagArray, @RequestParam(value="oldRegionArray", required=false) String oldRegionArray, @RequestParam(value="oldTimeArray", required=false) String oldTimeArray, @RequestParam(value="isBatch", required=false) String isBatch) {
        ResultModel rs = new ResultModel();
        if (StringUtil.isEmpty((CharSequence)businessArray) || StringUtil.isEmpty((CharSequence)tagArray)) {
            rs.setReturnValue((Object)false);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u53c2\u6570\u4e0d\u6b63\u786e");
        } else {
            try {
                this.mediaService.deleteTag(appkey, businessArray, tagArray, oldRegionArray, oldTimeArray, isBatch);
                rs.setReturnValue((Object)true);
                rs.setSuccessed(true);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                rs.setReturnValue((Object)false);
                rs.setSuccessed(false);
                rs.setErrorDesc("system error");
            }
        }
        return rs;
    }

    @LogBefore(operType="/media/tag/add", keyName="\u65b0\u589e\u6807\u7b7e")
    @PostMapping(value={"/media/tag/add"}, produces={"application/json"})
    public ResultModel<Boolean> batchAddTag(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="appkey") String appkey, @RequestParam(value="businessArray") String businessArray, @RequestParam(value="tagArray") String tagArray, @RequestParam(value="regionArray", required=false) String regionArray, @RequestParam(value="timeArray", required=false) String timeArray) {
        ResultModel rs = new ResultModel();
        try {
            this.mediaService.bathInsertTag(appkey, businessArray, tagArray, regionArray, timeArray);
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setReturnValue((Object)false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @LogBefore(operType="/media/tag/copy", keyName="\u65b0\u589e\u6807\u7b7e")
    @PostMapping(value={"/media/tag/copy"}, produces={"application/json"})
    public ResultModel<Boolean> batchAddTag(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="positionIds") String positionIds, @RequestParam(value="copyFromPositionId") String copyFromPositionId) {
        ResultModel rs = new ResultModel();
        try {
            this.mediaService.bathInsertByCopy(copyFromPositionId, positionIds);
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setReturnValue((Object)false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @LogBefore(operType="/media/tag/update", keyName="\u66f4\u65b0\u6807\u7b7e")
    @PostMapping(value={"/media/tag/update"}, produces={"application/json"})
    public ResultModel<Boolean> updateTag(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="appkey") String appkey, @RequestParam(value="business") String business, @RequestParam(value="oldTag") String oldTag, @RequestParam(value="oldRegionArray", required=false) String oldRegionArray, @RequestParam(value="oldTimeArray", required=false) String oldTimeArray, @RequestParam(value="newTag") String newTag, @RequestParam(value="regionArray", required=false) String regionArray, @RequestParam(value="timeArray", required=false) String timeArray) {
        ResultModel rs = new ResultModel();
        try {
            this.mediaService.updateTag(appkey, business, oldTag, newTag, regionArray, timeArray, oldRegionArray, oldTimeArray);
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setReturnValue((Object)false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @LogBefore(operType="/media/tag/oldtonew", keyName="\u540c\u6b65\u8001\u7cfb\u7edf\u6807\u7b7e\u9650\u5236")
    @GetMapping(value={"/media/tag/oldtonew"}, produces={"application/json"})
    @Deprecated
    public ResultModel<Boolean> oldToNew(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            this.mediaService.synchronizationTags();
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setReturnValue((Object)false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @LogBefore(operType="/media/tag/pusholdByPositionId", keyName="\u540c\u6b65\u5e7f\u544a\u4f4d\u6807\u7b7e")
    @GetMapping(value={"/media/tag/pusholdByPositionId"}, produces={"application/json"})
    @Deprecated
    public ResultModel<Boolean> pusholdByPositionId(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            this.mediaService.pusholdByPositionId();
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setReturnValue((Object)false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @LogBefore(operType="/ticket/pushTagsByTicketId", keyName="\u540c\u6b65\u5e7f\u544a\u5238\u6807\u7b7e")
    @GetMapping(value={"/ticket/pushTagsByTicketId"}, produces={"application/json"})
    @Deprecated
    public ResultModel<Boolean> synchronizationPushTicketTags(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            this.mediaService.pushTagsByTicketId();
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setReturnValue((Object)false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @LogBefore(operType="/tag/rollbackTagByPositionId", keyName="\u56de\u6eda\u7cfb\u7edf\u5e7f\u544a\u4f4d\u6807\u7b7e")
    @GetMapping(value={"/tag/rollbackTagByPositionId"}, produces={"application/json"})
    @Deprecated
    public ResultModel<Boolean> pushOld(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            this.mediaService.rollbackTagByPositionId();
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setReturnValue((Object)false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @LogBefore(operType="/tag/comparison", keyName="\u6bd4\u5bf9\u5e7f\u544a\u4f4d\u6807\u7b7e")
    @GetMapping(value={"/tag/comparison"}, produces={"application/json"})
    @Deprecated
    public ResultModel<Boolean> comparison(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            this.mediaService.comparison();
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setReturnValue((Object)false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @LogBefore(operType="/media/update", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/media/update"}, method={RequestMethod.POST})
    public ResultModel<Boolean> positionUpdate(@Validated PositionUpdateDto positionUpdateDto, HttpServletRequest request, HttpServletResponse response) {
        Boolean prepay = positionUpdateDto.getPrepay();
        String appKey = positionUpdateDto.getAppKey();
        User user = this.getUser(request, response);
        ProviderAppAdRO providerAppInfo = this.providerFacadeIntegration.getProviderAppInfoByAppKey(positionUpdateDto.getAppKey());
        Short advanceType = providerAppInfo.getAdvanceType();
        Boolean isUpdatePrePay = advanceType != null && (prepay != false && advanceType == 0 || prepay == false && advanceType == 1);
        if (isUpdatePrePay.booleanValue() && UserRoleCodeUtil.isNotMJLeader((User)user).booleanValue()) {
            return ResultModelFactory.FAIL500((String)"\u4ec5\u5a92\u4ecb\u7ecf\u7406\u6743\u9650\u53ef\u4ee5\u4fee\u6539\u9884\u4ed8\u7c7b\u578b");
        }
        positionUpdateDto.setModifier(user.getUsername());
        Boolean aBoolean = this.mediaService.updateProvider(positionUpdateDto);
        if (isUpdatePrePay.booleanValue()) {
            this.newAppEntranceFacadeIntegration.updateCooperationTypeByAppKey(appKey);
        }
        return ResultModelFactory.SUCCESS((Serializable)aBoolean);
    }

    @LogBefore(operType="/media/tag/insertAllPositionTag", keyName="\u65b0\u589e\u6240\u6709\u9ed1\u540d\u5355\u6807\u7b7e")
    @PostMapping(value={"/media/tag/insertAllPositionTag"}, produces={"application/json"})
    public ResultModel<Boolean> insertAllPositionTage(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="tagArray") String tagArray) {
        ResultModel rs = new ResultModel();
        try {
            List appRo = this.newAppEntranceFacadeIntegration.getAllList(new QueryAppEntranceParamDTO());
            System.out.println("\u603b\u5171\u6709\u8fd9\u4e48\u591a\u5e7f\u544a\u4f4d\uff1a" + appRo.size());
            if (CollectionUtils.isNotEmpty((Collection)appRo)) {
                HashMap map = new HashMap();
                for (AppEntranceAdRO ar : appRo) {
                    List<String> maList = new ArrayList<String>();
                    if (map.get(ar.getAppKey()) == null) {
                        maList.add(ar.getAppEntranceId().toString());
                    } else {
                        maList = (List)map.get(ar.getAppKey());
                        maList.add(ar.getAppEntranceId().toString());
                    }
                    map.put(ar.getAppKey(), maList);
                }
                System.out.println("\u603b\u5171\u8fd9\u4e48\u591a\u5f00\u53d1\u8005\uff1a" + map.size());
                for (String appKey : map.keySet()) {
                    List maString = (List)map.get(appKey);
                    if (maString.size() <= 0) continue;
                    this.mediaService.bathInsertTag(appKey, JSON.toJSONString((Object)maString), tagArray, null, null);
                }
                System.out.println("\u63a8\u9001\u5b8c\u6bd5");
            }
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setReturnValue((Object)false);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/media/tag/positionId"}, produces={"application/json"})
    public ResultModel<List<String>> queryTagsByPositionId(@RequestParam(value="positionId") String positionId) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.mediaService.queryTagsByPositionId(positionId));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5206\u7c7b\u6807\u7b7e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            return rs;
        }
        return rs;
    }

    @RequestMapping(value={"/media/getAuditPage"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<MediaAuditVO>> getAuditPage(@RequestParam(name="companyName", required=false) String companyName, @RequestParam(name="mediaName") String mediaName, @RequestParam(name="status") Byte status, @RequestParam(name="providerId", required=false, defaultValue="-1") Long providerId, @RequestParam(name="mjCode", required=false) String mjCode, @RequestParam(name="areaType", required=false) Integer areaType, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, HttpServletRequest request, HttpServletResponse response) {
        Boolean look_all;
        User user = this.getUser(request, response);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        if (!(look_all = Boolean.valueOf(user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode()))).booleanValue()) {
            mjCode = user.getUsername();
        }
        return ResultModelFactory.SUCCESS((Serializable)this.mediaService.getAuditPage(companyName, mediaName, mjCode, status, providerId, areaType, pageNum, pageSize));
    }

    @LogBefore(operType="/media/audit", keyName="\u5ba1\u6838\u5a92\u4f53")
    @RequestMapping(value={"/media/audit"}, method={RequestMethod.POST})
    public ResultModel<Boolean> audit(@RequestParam(value="id") Long id, @RequestParam(value="auditPass") Boolean auditPass, @RequestParam(name=" ", required=false) String refuseReason, @RequestParam(name="reviewRefuseIds", required=false) String reviewRefuseIds, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        Boolean isMJ = user.getRoleCodes().contains(RoleEnum.MJ.getCode()) || user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode());
        Boolean fk = user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
        if (!isMJ.booleanValue() && !fk.booleanValue()) {
            ResultModel rs = new ResultModel();
            String desc = "\u53ea\u6709\u5a92\u4ecb/\u5a92\u4ecb\u7ecf\u7406/\u98ce\u63a7\u89d2\u8272\u53ef\u4ee5\u64cd\u4f5c\u5ba1\u6838\uff01";
            LOGGER.error(desc);
            rs.setSuccessed(false);
            rs.setErrorDesc(desc);
            return rs;
        }
        Boolean audit = this.newMediaFacadeIntegration.audit(id, auditPass, isMJ, refuseReason, reviewRefuseIds, user.getUsername());
        if (auditPass.booleanValue() && isMJ.booleanValue()) {
            isMJ = false;
            audit = this.newMediaFacadeIntegration.audit(id, auditPass, isMJ, refuseReason, reviewRefuseIds, user.getUsername());
        }
        return ResultModelFactory.SUCCESS((Serializable)audit);
    }

    @LogBefore(operType="/media/updateTags", keyName="\u4fee\u6539\u5a92\u4f53\u6807\u7b7e")
    @RequestMapping(value={"/media/updateTags"}, method={RequestMethod.POST})
    public ResultModel<Boolean> updateTags(@RequestParam(value="id") Long id, @RequestParam(value="tags") String tags, HttpServletRequest request, HttpServletResponse response) {
        return ResultModelFactory.SUCCESS((Serializable)this.newMediaFacadeIntegration.updateTags(id, tags, this.getUser(request, response).getUsername()));
    }

    @RequestMapping(value={"/media/updateHighestPositions"}, method={RequestMethod.POST})
    public ResultModel updateHighestPositions(@RequestParam(value="positionId") String positionId, @RequestParam(value="highestPositionStatus") Boolean highestPositionStatus) {
        if (StringUtils.isBlank((CharSequence)positionId) || highestPositionStatus == null) {
            return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u4f4d\u4e0d\u80fd\u4e3anull");
        }
        try {
            this.mediaService.updateHighestPositions(positionId, highestPositionStatus);
            return ResultModelFactory.SUCCESS((Serializable)((Object)"OK"));
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/media/position/directWithTicket/ratio"}, method={RequestMethod.POST})
    public ResultModel setPositionDirectFlow(HttpServletRequest servletRequest, HttpServletResponse servletResponse, @RequestParam(value="positionId") String positionId, @RequestParam(value="directTicketRatio") Integer directTicketRatio) {
        boolean isMjLeader;
        if (StringUtils.isBlank((CharSequence)positionId)) {
            throw new BusinessException("\u8bf7\u5148\u9009\u62e9\u5e7f\u544a\u4f4d");
        }
        if (directTicketRatio == null || directTicketRatio < 0 || directTicketRatio > 100) {
            throw new BusinessException("\u6bd4\u4f8b\u5927\u5c0f\u8bbe\u7f6e\u6709\u8bef");
        }
        PositionDirectFlowAssignDto positionDirectFlowAssignDto = new PositionDirectFlowAssignDto();
        positionDirectFlowAssignDto.setPositionId(positionId);
        positionDirectFlowAssignDto.setDirectTicketRatio(directTicketRatio);
        User user = this.getUser(servletRequest, servletResponse);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        if (!(isMjLeader = user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()))) {
            throw new BusinessException("\u4ec5\u5bf9\u5a92\u4ecb\u7ecf\u7406\u5f00\u653e");
        }
        boolean haveDirecter = this.mediaService.setPositionDirectFlow(positionDirectFlowAssignDto);
        if (haveDirecter) {
            return ResultModelFactory.SUCCESS((Serializable)((Object)"OK"));
        }
        return ResultModelFactory.FAIL400((String)"\u8be5\u5e7f\u544a\u4f4d\u65e0\u76f4\u6295\u5238,\u65e0\u6cd5\u5206\u914d\u76f4\u6295\u5238\u6d41\u91cf");
    }
}

