/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.media;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.rtb.RtbRatioControl;
import com.bxm.adsmanager.model.dao.rtb.RtbSpeedControl;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.CvrStatisticDto;
import com.bxm.adsmanager.model.dto.rtb.PositionRtbDto;
import com.bxm.adsmanager.model.vo.rtb.PositionRtbVo;
import com.bxm.adsmanager.service.rtb.PositionRTBService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MediaRTBController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaRTBController.class);
    @Autowired
    PositionRTBService positionRTBService;

    @RequestMapping(value={"/position/getPositionrtb"}, method={RequestMethod.GET})
    public ResultModel<PositionRtbVo> getPositionrtb(@RequestParam(value="positionId") String positionId) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.positionRTBService.getPositionRtbByPositionId(positionId));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u4f4drtb\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u5e7f\u544a\u4f4drtb\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }

    @LogBefore(operType="/position/setPositionrtb", keyName="\u4fee\u6539rtb\u914d\u7f6e")
    @RequestMapping(value={"/position/setPositionrtb"})
    public ResultModel setPositionrtb(HttpServletRequest request, HttpServletResponse response, PositionRtbDto positionRtbDto) {
        this.checkPositionRtb(positionRtbDto);
        ResultModel resultModel = new ResultModel();
        try {
            User user = this.getUser(request, response);
            this.positionRTBService.saveOrUpdate(positionRtbDto, user);
            resultModel.setReturnValue((Object)true);
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u5e7f\u544a\u4f4drtb\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u65b0\u589e\u5e7f\u544a\u4f4drtb\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }

    private void checkPositionRtb(PositionRtbDto positionRtbDto) {
        String activityControlJson;
        String ticketControlJson;
        if (StringUtils.isBlank((CharSequence)positionRtbDto.getPositionIds()) || StringUtils.isBlank((CharSequence)positionRtbDto.getHeadTicketJson())) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String ratioControlJson = positionRtbDto.getRatioControlJson();
        if (StringUtils.isNotBlank((CharSequence)ratioControlJson)) {
            List rtbRatioControls = JSONObject.parseArray((String)ratioControlJson, RtbRatioControl.class);
            for (RtbRatioControl rtbRatioControl : rtbRatioControls) {
                if (Objects.nonNull(rtbRatioControl.getCvr())) {
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)rtbRatioControl.getAdGroupId()), (Object)"\u53c2\u6570adgroupId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (Objects.isNull(rtbRatioControl.getCost()) && Objects.isNull(rtbRatioControl.getCvr())) {
                    Preconditions.checkArgument((Objects.nonNull(rtbRatioControl.getShallowRatio()) || Objects.nonNull(rtbRatioControl.getDeepRatio()) ? 1 : 0) != 0, (Object)"\u53c2\u6570shallowRatio\u6216deepRatio\u4e0d\u80fd\u4e3a\u7a7a");
                }
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)rtbRatioControl.getStartTime()), (Object)"\u53c2\u6570startTime\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)rtbRatioControl.getEndTime()), (Object)"\u53c2\u6570endTime\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)Objects.nonNull(rtbRatioControl.getEnable()), (Object)"\u53c2\u6570enable\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(ticketControlJson = positionRtbDto.getTicketControlJson()))) {
            List ticketControls = JSONObject.parseArray((String)ticketControlJson, RtbSpeedControl.class);
            for (RtbSpeedControl ticketControl : ticketControls) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)ticketControl.getStartTime()), (Object)"\u53c2\u6570startTime\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)ticketControl.getEndTime()), (Object)"\u53c2\u6570endTime\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)Objects.nonNull(ticketControl.getEnable()), (Object)"\u53c2\u6570enable\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((Objects.nonNull(ticketControl.getCount()) && ticketControl.getCount() > 0 ? 1 : 0) != 0, (Object)"\u53c2\u6570count\u4e0d\u6b63\u786e");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)ticketControl.getAdTicketId()), (Object)"\u53c2\u6570adTicketId\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(activityControlJson = positionRtbDto.getActivityControlJson()))) {
            List activityControls = JSONObject.parseArray((String)activityControlJson, RtbSpeedControl.class);
            for (RtbSpeedControl activityControl : activityControls) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)activityControl.getStartTime()), (Object)"\u53c2\u6570startTime\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)activityControl.getEndTime()), (Object)"\u53c2\u6570endTime\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)Objects.nonNull(activityControl.getEnable()), (Object)"\u53c2\u6570enable\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((Objects.nonNull(activityControl.getCount()) && activityControl.getCount() > 0 ? 1 : 0) != 0, (Object)"\u53c2\u6570count\u4e0d\u6b63\u786e");
                Preconditions.checkArgument((boolean)StringUtils.isBlank((CharSequence)activityControl.getAdTicketId()), (Object)"\u6d3b\u52a8\u914d\u7f6e\u4e2d\u53c2\u6570adTicketId\u4e0d\u80fd\u6709\u503c");
            }
        }
    }

    @RequestMapping(value={"/position/getNewPositionIds"}, method={RequestMethod.GET})
    public ResultModel getNewPositionIds(@RequestParam(name="positionIds") String positionIds) {
        List list = new ArrayList();
        try {
            list = this.positionRTBService.getNewPositionIds(positionIds);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u662f\u5426\u65b0rtb\u5e7f\u544a\u4f4d\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u662f\u5426\u65b0rtb\u5e7f\u544a\u4f4d\u4fe1\u606f\u51fa\u9519");
        }
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue(list);
        return resultModel;
    }

    @RequestMapping(value={"/position/getTicketByIds"}, method={RequestMethod.GET})
    public ResultModel getTicketByIds(@RequestParam(name="ticketIds") String ticketIds) {
        List list = new ArrayList();
        try {
            list = this.positionRTBService.getTicketByIds(ticketIds);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u5238\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u5e7f\u544a\u5238\u4fe1\u606f\u51fa\u9519");
        }
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue(list);
        return resultModel;
    }

    @RequestMapping(value={"/position/getCvrStatistic"}, method={RequestMethod.GET})
    public ResultModel getCvrStatistic(CvrStatisticDto cvrStatisticDto) {
        List cvrStatistic = this.positionRTBService.getCvrStatistic(cvrStatisticDto);
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)cvrStatistic);
        return resultModel;
    }

    static class test {
        String ticketIds;
        Integer targetOneBxm;
        Integer targetTwoBxm;

        public String getTicketIds() {
            return this.ticketIds;
        }

        public Integer getTargetOneBxm() {
            return this.targetOneBxm;
        }

        public Integer getTargetTwoBxm() {
            return this.targetTwoBxm;
        }

        public void setTicketIds(String ticketIds) {
            this.ticketIds = ticketIds;
        }

        public void setTargetOneBxm(Integer targetOneBxm) {
            this.targetOneBxm = targetOneBxm;
        }

        public void setTargetTwoBxm(Integer targetTwoBxm) {
            this.targetTwoBxm = targetTwoBxm;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof test)) {
                return false;
            }
            test other = (test)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ticketIds = this.getTicketIds();
            String other$ticketIds = other.getTicketIds();
            if (this$ticketIds == null ? other$ticketIds != null : !this$ticketIds.equals(other$ticketIds)) {
                return false;
            }
            Integer this$targetOneBxm = this.getTargetOneBxm();
            Integer other$targetOneBxm = other.getTargetOneBxm();
            if (this$targetOneBxm == null ? other$targetOneBxm != null : !((Object)this$targetOneBxm).equals(other$targetOneBxm)) {
                return false;
            }
            Integer this$targetTwoBxm = this.getTargetTwoBxm();
            Integer other$targetTwoBxm = other.getTargetTwoBxm();
            return !(this$targetTwoBxm == null ? other$targetTwoBxm != null : !((Object)this$targetTwoBxm).equals(other$targetTwoBxm));
        }

        protected boolean canEqual(Object other) {
            return other instanceof test;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ticketIds = this.getTicketIds();
            result = result * 59 + ($ticketIds == null ? 43 : $ticketIds.hashCode());
            Integer $targetOneBxm = this.getTargetOneBxm();
            result = result * 59 + ($targetOneBxm == null ? 43 : ((Object)$targetOneBxm).hashCode());
            Integer $targetTwoBxm = this.getTargetTwoBxm();
            result = result * 59 + ($targetTwoBxm == null ? 43 : ((Object)$targetTwoBxm).hashCode());
            return result;
        }

        public String toString() {
            return "MediaRTBController.test(ticketIds=" + this.getTicketIds() + ", targetOneBxm=" + this.getTargetOneBxm() + ", targetTwoBxm=" + this.getTargetTwoBxm() + ")";
        }
    }
}

