/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.outsidte;

import com.bxm.adsmanager.model.dto.outside.AdTicketOutsideDto;
import com.bxm.adsmanager.model.vo.outside.AdticketOutsideVo;
import com.bxm.adsmanager.service.outside.AdticketOutsideService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.math.BigInteger;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ticket/outside"})
public class TicketOutsideController {
    @Autowired
    AdticketOutsideService adticketOutsideService;

    @LogBefore(operType="/ticket/outside/add", keyName="\u65b0\u589e\u5916\u6295\u94fe\u63a5\u63a8\u9001redis")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdTicketOutsideDto adTicketOutsideDto) {
        ConstraintViolation constraintViolation = BeanValidator.validate((Object)adTicketOutsideDto);
        if (constraintViolation != null) {
            return ResultModelFactory.FAIL400((String)constraintViolation.getMessage());
        }
        this.adticketOutsideService.add(adTicketOutsideDto);
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/getAssetTicketInfo"}, method={RequestMethod.GET})
    public ResultModel getAssetTicketInfo(BigInteger assetId) {
        ResultModel resultModel = new ResultModel();
        List adticketOutsideVoList = this.adticketOutsideService.getAssetTicketInfo(assetId);
        resultModel.setReturnValue((Object)adticketOutsideVoList);
        return resultModel;
    }

    @RequestMapping(value={"/findAllAssetsByTicketId"}, method={RequestMethod.GET})
    public ResultModel<List<AdticketOutsideVo>> findAllAssetsByTicketId(@RequestParam(required=true, name="ticketId") Long ticketId) {
        ResultModel rs = new ResultModel();
        List list = this.adticketOutsideService.findAllAssetsById(ticketId);
        rs.setReturnValue((Object)list);
        return rs;
    }
}

