/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.precharge;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.facade.model.precharge.PrechargeCorrectSearchDTO;
import com.bxm.adsmanager.model.dao.precharge.PrechargeCorrectRecord;
import com.bxm.adsmanager.model.dto.PrechargeCorrectDTO;
import com.bxm.adsmanager.service.precharge.PrechargeCorrectService;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/precharge/correct"})
public class PrechargeCorrectController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(PrechargeCorrectController.class);
    @Autowired
    private PrechargeCorrectService prechargeCorrectService;

    @PostMapping(value={"/add"})
    public ResultModel add(@Validated PrechargeCorrectDTO dto) {
        if (dto.getCorrectAmount().compareTo(BigDecimal.ZERO) <= 0) {
            return ResultModelFactory.FAILED400((String)"\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6574\u6570");
        }
        if (!dto.getCorrectType().equals(PrechargeCorrectRecord.CORRECT_TYPE_PLUS) && !dto.getCorrectType().equals(PrechargeCorrectRecord.CORRECT_TYPE_SUBTRACT)) {
            return ResultModelFactory.FAILED400((String)"\u4fee\u6b63\u7c7b\u578b\u6709\u8bef");
        }
        dto.setCreateUser(RequestUtils.getCurrentRealName());
        try {
            this.prechargeCorrectService.add(dto);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAILED400((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAILED500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @GetMapping(value={"/logs"})
    public ResultModel getRecordList(PrechargeCorrectSearchDTO searchDTO) {
        if (null == searchDTO.getAccountId()) {
            return ResultModelFactory.FAILED400((String)"accountId\u4e3a\u7a7a");
        }
        List list = this.prechargeCorrectService.getRecordList(searchDTO).getList();
        return ResultModelFactory.SUCCESS((Object)list);
    }
}

