/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.precharge;

import com.bxm.acl.facade.model.UserVo;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.facade.model.precharge.PrechargeDTO;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.PrechargeConfigVo;
import com.bxm.adsmanager.service.precharge.PrechargeService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.bxm.warcar.validate.ValidateException;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/precharge"})
public class PrechargeNewController {
    private static final Logger log = LoggerFactory.getLogger(PrechargeNewController.class);
    @Autowired
    private PrechargeService prechargeService;

    @GetMapping(value={"/config/list"})
    public ResultModel listPrechargeConfig(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="account", required=false) String account, @RequestParam(value="providerKeyword", required=false) String providerKeyword, @RequestParam(value="correctStatus", required=false) Byte correctStatus, @RequestParam(value="dateTime", required=false) String dateTime) {
        UserVo currentUser = RequestUtils.getCurrentUser();
        List roleCodes = currentUser.getRoleCodes();
        String mjCode = "";
        if (!roleCodes.contains(RoleEnum.MJLEADER.getCode()) && roleCodes.contains(RoleEnum.MJ.getCode())) {
            mjCode = currentUser.getUsername();
        }
        PageInfo pageInfo = this.prechargeService.listPrechargeConfig(pageNum, pageSize, account, providerKeyword, correctStatus, dateTime, mjCode, null);
        return ResultModelFactory.SUCCESS((Object)pageInfo);
    }

    @PostMapping(value={"/config/add"})
    @LogBefore(operType="/precharge/config/add", keyName="\u65b0\u589e\u9884\u4ed8\u914d\u7f6e")
    public ResultModel addPrechargeConfig(@Validated PrechargeDTO dto) {
        try {
            this.prechargeService.addPrechargeConfig(dto);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAILED500((String)e.getMessage());
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAILED500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping(value={"/config/update"})
    @LogBefore(operType="/precharge/config/update", keyName="\u7f16\u8f91\u9884\u4ed8\u914d\u7f6e")
    public ResultModel updatePrechargeConfig(@Validated PrechargeDTO dto) {
        try {
            this.prechargeService.updatePrechargeConfig(dto);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAILED500((String)e.getMessage());
        }
        catch (ValidateException e) {
            return ResultModelFactory.FAILED400((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAILED500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @GetMapping(value={"/config/export"})
    public void exportPrechargeConfig(@RequestParam(value="account", required=false) String account, @RequestParam(value="positionName", required=false) String positionName, @RequestParam(value="correctStatus", required=false) Byte correctStatus, @RequestParam(value="dateTime", required=false) String dateTime, HttpServletResponse response) {
        PageInfo pageInfo = this.prechargeService.listPrechargeConfig(Integer.valueOf(1), Integer.valueOf(10000), account, positionName, correctStatus, dateTime, null, null);
        List list = pageInfo.getList();
        list.forEach(l -> {
            if (l.getCorrectStatus() != null) {
                switch (l.getCorrectStatus()) {
                    case 0: {
                        l.setCorrectStatusForExcel("\u5f85\u5ba1\u6838");
                        break;
                    }
                    case 1: {
                        l.setCorrectStatusForExcel("\u5ba1\u6838\u6210\u529f");
                        break;
                    }
                    case 2: {
                        l.setCorrectStatusForExcel("\u5ba1\u6838\u5931\u8d25");
                    }
                }
            }
        });
        ExcelUtil.exportExcel((List)list, null, (String)"\u9884\u4ed8\u7ba1\u7406\u5217\u8868", PrechargeConfigVo.class, (String)"\u9884\u4ed8\u7ba1\u7406\u5217\u8868\u5bfc\u51fa.xls", (HttpServletResponse)response);
    }
}

