/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.report;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOcpcConf;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.ocpc.OcpcStatisticsConditionDto;
import com.bxm.adsmanager.model.vo.report.OcpcOffersVo;
import com.bxm.adsmanager.model.vo.report.OcpcStatisticsVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketOcpcService;
import com.bxm.adsmanager.service.datapark.DataparkOcpcService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmanager.web.convert.report.OcpcOffersConvert;
import com.bxm.adsmanager.web.convert.report.OcpcStatisticsConvert;
import com.bxm.adsmedia.facade.enumdata.MediaTypeEnum;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ocpc.OcpcOffers;
import com.bxm.datapark.facade.ocpc.OcpcOffersCondition;
import com.bxm.datapark.facade.ocpc.OcpcStatistics;
import com.bxm.datapark.facade.ocpc.OcpcStatisticsCondition;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ocpc"})
public class OcpcReportController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpcReportController.class);
    @Autowired
    private DataparkOcpcService dataparkOcpcService;
    @Autowired
    private AdTicketOcpcService adTicketOcpcService;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @RequestMapping(value={"/find"}, method={RequestMethod.POST})
    public ResultModel<Page<OcpcStatisticsVo>> find(OcpcStatisticsConditionDto condition, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        List ticektIds = Lists.newArrayList();
        ResultModel resultModel = new ResultModel();
        if (StringUtils.isNotBlank((String)UserRoleCodeUtil.isAe((User)user)) && CollectionUtils.isEmpty((Collection)(ticektIds = this.adTicketOcpcService.findByAeOrSale(user.getUsername(), null)))) {
            resultModel.setReturnValue((Object)new Page());
            return resultModel;
        }
        if (StringUtils.isNotBlank((String)UserRoleCodeUtil.isSale((User)user))) {
            AdvertiserDto advertiserDto = new AdvertiserDto();
            advertiserDto.setSale(user.getUsername());
            try {
                List advertiserDtos = this.adShopIntegration.getAdShopList(advertiserDto);
                ArrayList advertiserIds = Lists.newArrayList();
                if (CollectionUtils.isEmpty((Collection)advertiserDtos)) {
                    resultModel.setReturnValue((Object)new Page());
                    return resultModel;
                }
                for (AdvertiserDto advertiserDtoTemp : advertiserDtos) {
                    advertiserIds.add(advertiserDtoTemp.getId());
                }
                ticektIds = this.adTicketOcpcService.findByAeOrSale(null, (List)advertiserIds);
                if (CollectionUtils.isEmpty((Collection)ticektIds)) {
                    resultModel.setReturnValue((Object)new Page());
                    return resultModel;
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)ticektIds)) {
            String tickets = JSON.toJSONString((Object)ticektIds);
            condition.setTicketIds(tickets);
        }
        if (condition != null && (StringUtils.isNotBlank((String)condition.getMediaType()) || StringUtils.isNotBlank((String)condition.getMediaClassId()) || StringUtils.isNotBlank((String)condition.getMediaChildClassId()))) {
            List positionIds;
            QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
            paramDTO.setMediaSysType(condition.getMediaType());
            if (StringUtils.isNotBlank((String)condition.getMediaClassId()) && StringUtils.isNumeric((String)condition.getMediaClassId())) {
                paramDTO.setMediaClassId(Long.valueOf(condition.getMediaClassId()));
            }
            if (StringUtils.isNotBlank((String)condition.getMediaChildClassId()) && StringUtils.isNumeric((String)condition.getMediaChildClassId())) {
                paramDTO.setMediaChildClassId(Long.valueOf(condition.getMediaChildClassId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)(positionIds = this.newAppEntranceFacadeIntegration.getAllPositionIds(paramDTO)))) {
                condition.setPositionIdList(positionIds);
            } else {
                resultModel.setReturnValue((Object)new Page());
                return resultModel;
            }
        }
        Page result = this.dataparkOcpcService.find((OcpcStatisticsCondition)condition);
        List<Object> voList = Lists.newArrayList();
        List list = result.getList();
        for (OcpcStatistics orig : list) {
            OcpcStatisticsVo vo = OcpcStatisticsConvert.convert(orig);
            Integer ticketid = orig.getTicketid();
            if (null != ticketid) {
                AdTicketOcpcConf conf;
                if (StringUtils.isNotBlank((String)orig.getPosition())) {
                    boolean closed = this.dataparkOcpcService.isClosed(String.valueOf(ticketid), orig.getPosition());
                    vo.setStatus(Integer.valueOf(closed ? 0 : 1));
                }
                if (null != (conf = this.adTicketOcpcService.selectByTicketId(TypeHelper.castToLong((Object)ticketid)))) {
                    vo.setExpectCpa(conf.getCpaExpectPrice());
                }
            }
            voList.add(vo);
        }
        voList = this.generateResultData((List<OcpcStatisticsVo>)voList);
        return ResultModelFactory.SUCCESS((Serializable)new Page((List)voList, result.getPageNum(), result.getPageSize(), result.getTotal()));
    }

    @RequestMapping(value={"/offers"})
    public ResultModel<Page<OcpcOffersVo>> find(OcpcOffersConditionDto condition) {
        OcpcOffersCondition e = OcpcOffersConvert.convert(condition);
        ArrayList voList = Lists.newArrayList();
        Page result = this.dataparkOcpcService.find(e);
        List offersList = result.getList();
        if (CollectionUtils.isEmpty((Collection)offersList)) {
            return ResultModelFactory.SUCCESS();
        }
        for (OcpcOffers ocpcOffers : offersList) {
            voList.add(OcpcOffersConvert.convert(ocpcOffers));
        }
        return ResultModelFactory.SUCCESS((Serializable)new Page((List)voList, result.getPageNum(), result.getPageSize(), result.getTotal()));
    }

    @RequestMapping(value={"/reset"})
    public ResultModel reset(String position, String ticketid) {
        return ResultModelFactory.FAIL400((String)"\u65b9\u6cd5\u5df2\u88ab\u9057\u5f03");
    }

    private List<OcpcStatisticsVo> generateResultData(List<OcpcStatisticsVo> resultList) {
        if (CollectionUtils.isNotEmpty(resultList)) {
            ArrayList positionIds = new ArrayList();
            resultList.forEach(ocpcStatisticsVo -> positionIds.add(ocpcStatisticsVo.getPosition()));
            QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
            paramDTO.setPositionIds(positionIds);
            List positionDataList = this.newAppEntranceFacadeIntegration.getAllList(paramDTO);
            HashMap mediaTypeMap = new HashMap();
            HashMap mediaClassMap = new HashMap();
            HashMap mediaChildClassMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)positionDataList)) {
                positionDataList.forEach(appEntranceAdRo -> {
                    String positionId = appEntranceAdRo.getPositionId();
                    if (null != appEntranceAdRo.getMediaClassId()) {
                        mediaClassMap.put(positionId, appEntranceAdRo.getMediaClassName());
                    }
                    if (null != appEntranceAdRo.getMediaChildClassId()) {
                        mediaChildClassMap.put(positionId, appEntranceAdRo.getMediaChildClassName());
                    }
                    mediaTypeMap.put(positionId, appEntranceAdRo.getMediaSysType());
                });
            }
            resultList.forEach(ocpcStatisticsVo -> {
                String positionId = ocpcStatisticsVo.getPosition();
                ocpcStatisticsVo.setMediaClass((String)mediaClassMap.get(positionId));
                ocpcStatisticsVo.setMediaChildClass((String)mediaChildClassMap.get(positionId));
                ocpcStatisticsVo.setMediaTypeName(MediaTypeEnum.getMediaTypeNameByCode((String)((String)mediaTypeMap.get(positionId))));
            });
            return resultList;
        }
        return Collections.emptyList();
    }

    public static class OcpcOffersConditionDto {
        private Integer ticketid;
        private String position;
        private String start;
        private String end;
        private Integer pageNum = 1;
        private Integer pageSize = 20;

        public Integer getTicketid() {
            return this.ticketid;
        }

        public void setTicketid(Integer ticketid) {
            this.ticketid = ticketid;
        }

        public String getPosition() {
            return this.position;
        }

        public void setPosition(String position) {
            this.position = position;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }
}

