/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.tbladtag;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.tbltag.TblAdPostionTag;
import com.bxm.adsmanager.model.dto.tbltag.TblAdTagDto;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagDropdownBoxVo;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.CollectionDataCopyUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"tbladtag/"})
public class TblAdTagController
extends BaseController {
    private Logger log = LoggerFactory.getLogger(TblAdTagController.class);
    @Autowired
    private TblAdTagService tblAdTagService;

    @RequestMapping(value={"find/tblAdTagByType"}, method={RequestMethod.GET})
    public ResultModel<List<TblAdTagVo>> findTblAdTagListByType(@RequestParam(value="parentId") Integer parentId, @RequestParam(value="type") Integer type) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.tblAdTagService.findTblAdTagListByType(parentId, type));
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/tblAdTagByParentId"})
    public ResultModel<List<TblAdTagVo>> findTblAdTagByParentId(@RequestParam(value="id") Integer id) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.tblAdTagService.findTblAdTagById(id));
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"update/findEntityById"})
    public ResultModel<TblAdTagVo> updateFindById(@RequestParam(value="id") Integer id, @RequestParam(value="type") Integer type) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.tblAdTagService.updateFindTblAdTag(id, type));
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"save/tblAdTag"}, method={RequestMethod.POST})
    public ResultModel<String> saveTag(@RequestParam(value="parentId") Integer parentId, @RequestParam(value="name") String name, @RequestParam(value="typeTag") String typeTag, HttpServletRequest request, HttpServletResponse response) {
        ResultModel resultModel = new ResultModel();
        try {
            TblAdPostionTag tblAdTag = new TblAdPostionTag();
            tblAdTag.setTypeTag(Integer.valueOf(typeTag));
            tblAdTag.setName(name);
            tblAdTag.setCreateUser(this.getUser(request, response).getUsername());
            tblAdTag.setParentId(parentId);
            tblAdTag = this.tblAdTagService.addTag(tblAdTag);
            if (tblAdTag != null) {
                resultModel.setReturnValue((Object)"\u5f55\u5165\u6210\u529f\uff01");
                resultModel.setSuccessed(true);
            } else {
                resultModel.setReturnValue((Object)"\u5f55\u5165\u5931\u8d25\uff01");
                resultModel.setSuccessed(false);
            }
            if (Integer.valueOf(typeTag) == 2 && parentId != 0) {
                this.tblAdTagService.insertMediaTag(parentId, tblAdTag.getCode().toString());
            }
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"update/tblAdTag"}, method={RequestMethod.POST})
    public ResultModel<String> updateTag(TblAdTagDto tblAdTagDto, HttpServletRequest request, HttpServletResponse response) {
        ResultModel resultModel = new ResultModel();
        if (BeanValidator.validateGroup((Object)tblAdTagDto, (Class[])new Class[]{TblAdTagDto.Update.class}) != null) {
            return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)tblAdTagDto, (Class[])new Class[]{TblAdTagDto.Update.class}).getMessage());
        }
        try {
            if (this.tblAdTagService.updateTag(tblAdTagDto, this.getUser(request, response).getUsername()).booleanValue()) {
                resultModel.setSuccessed(true);
                resultModel.setReturnValue((Object)"\u4fee\u6539\u6210\u529f\uff01");
            } else {
                resultModel.setSuccessed(false);
                resultModel.setReturnValue((Object)"\u4fee\u6539\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u4fee\u6539\u5931\u8d25:" + e.getMessage());
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/TblAdTagListByParam"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<TblAdTagVo>> findTblAdTagListByParam(@RequestParam(value="param", defaultValue="") String param, @RequestParam(value="type", defaultValue="") String type, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        ResultModel resultModel = new ResultModel();
        PageHelper.startPage((int)pageNum, (int)pageSize);
        try {
            resultModel.setReturnValue((Object)this.tblAdTagService.findfindTblAdTagByNameAndID(param, type));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/TblTagAll"})
    public ResultModel<PageInfo<TblAdTagVo>> findAllTblTag(@RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="name", defaultValue="") String name) {
        ResultModel resultModel = new ResultModel();
        try {
            PageInfo list = this.tblAdTagService.findAll(pageNum, pageSize, name);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue((Object)list);
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/TblTagByCodeStr"}, method={RequestMethod.GET})
    public ResultModel<JSONObject> findTblTagByCodeStr(@RequestParam(value="codeStr") String codeStr) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.tblAdTagService.findTblAdTagByCodeStr(codeStr));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/tblTagByFirstCode"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<List<TblAdTagVo>> tblTagByFirstCode() {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.tblAdTagService.tblTagByFirstCode());
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/findNewTreeAll"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<PageInfo<TblAdTagVo>> findNewTreeAll(@RequestParam(value="parentId", defaultValue="0") Integer parentId, @RequestParam(value="type", defaultValue="1") Integer type, @RequestParam(value="name", defaultValue="") String name, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        ResultModel resultModel = new ResultModel();
        try {
            PageInfo pag = this.tblAdTagService.findNewTreeAll(pageNum, pageSize, type, name, parentId);
            resultModel.setReturnValue((Object)pag);
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"find/findNewAll"})
    public ResultModel<PageInfo<TblAdTagVo>> findNewAll(@RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="name", defaultValue="") String name, @RequestParam(value="type", defaultValue="1") Integer type) {
        ResultModel resultModel = new ResultModel();
        try {
            PageInfo list = this.tblAdTagService.findNewAll(pageNum, pageSize, name, type);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue((Object)list);
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u8be2\u51fa\u9519\uff01");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return resultModel;
    }

    @RequestMapping(value={"findOneLevelTag"})
    public ResultModel<List<TblAdTagDropdownBoxVo>> findOneLevelTag(Integer tagType) {
        if (null == tagType) {
            tagType = CommonConstant.TicketTag.TAG_TYPE_CLASSIFY;
        }
        ResultModel resultModel = new ResultModel();
        List tblAdPostionTags = this.tblAdTagService.findOneLevelTag(tagType);
        if (CollectionUtils.isEmpty((Collection)tblAdPostionTags)) {
            resultModel.setReturnValue(Collections.emptyList());
            return resultModel;
        }
        resultModel.setReturnValue((Object)CollectionDataCopyUtil.copyList((List)tblAdPostionTags, TblAdTagDropdownBoxVo.class));
        return resultModel;
    }

    @RequestMapping(value={"/getTagCode"}, method={RequestMethod.GET})
    public ResultModel<List<TblAdTagDropdownBoxVo>> getTagCode(@RequestParam(value="tagCode") String tagCode) {
        ResultModel resultModel = new ResultModel();
        List list = this.tblAdTagService.getTagCode(tagCode);
        if (CollectionUtils.isEmpty((Collection)list)) {
            resultModel.setReturnValue(Collections.emptyList());
            return resultModel;
        }
        resultModel.setReturnValue((Object)CollectionDataCopyUtil.copyList((List)list, TblAdTagDropdownBoxVo.class));
        return resultModel;
    }
}

