/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.third;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.vo.kuaishou.KuaishouAuthResponse;
import com.bxm.adsmanager.model.vo.kuaishou.KuaishouTokenVo;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.DateUtil;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class KuaishouController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(KuaishouController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(KuaishouController.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="rtbJedisUpdater")
    private JedisUpdater rtbJedisUpdater;
    private static final String tokenUrl = "https://ad.e.kuaishou.com/rest/openapi/oauth2/authorize/access_token";

    @RequestMapping(value={"/kuaishou/callback"}, produces={"application/json"})
    public String save(@RequestParam(value="auth_code") String auth_code, @RequestParam(value="appKey") String appKey) {
        log.info("kuaishou auth callback auth_code= {}, appKey= {}", (Object)auth_code, (Object)appKey);
        try {
            String appIdAndSecret = (String)this.fetcher.hfetch(RedisKeys.hashKuaishouAppIdConfig(), appKey, String.class);
            String appId = null;
            String secret = null;
            if (StringUtils.isNotBlank((CharSequence)appIdAndSecret)) {
                String[] split = appIdAndSecret.split(",");
                appId = split[0];
                secret = split[1];
            }
            if (StringUtils.isBlank(appId)) {
                return "\u6388\u6743\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6eappId";
            }
            HashMap params = Maps.newHashMap();
            params.put("app_id", appId);
            params.put("secret", secret);
            params.put("auth_code", auth_code);
            String result = OkHttpUtils.postRequestBody((String)tokenUrl, (Object)params, new HashMap());
            log.info("kuaishou request token response: {} | appKey :{}", (Object)result, (Object)appKey);
            KuaishouAuthResponse kuaishouAuthResponse = (KuaishouAuthResponse)JsonHelper.convert((String)result, KuaishouAuthResponse.class);
            if (Objects.nonNull(kuaishouAuthResponse)) {
                if (!Objects.equals(kuaishouAuthResponse.getCode(), 0)) {
                    return null;
                }
                KuaishouAuthResponse.Data data = kuaishouAuthResponse.getData();
                Long exDate = System.currentTimeMillis() + Long.valueOf(data.getAccess_token_expires_in().intValue()) * 1000L;
                Long refreshExDate = System.currentTimeMillis() + Long.valueOf(data.getRefresh_token_expires_in().intValue()) * 1000L;
                List advertiser_ids = data.getAdvertiser_ids();
                String access_token = data.getAccess_token();
                String refresh_token = data.getRefresh_token();
                String exDateFormat = DateUtil.dateTo14String((Date)new Date(exDate));
                KuaishouTokenVo kuaishouTokenVo = new KuaishouTokenVo();
                kuaishouTokenVo.setToken(access_token);
                kuaishouTokenVo.setRefreshToken(refresh_token);
                kuaishouTokenVo.setTokenExpireTime(exDateFormat);
                kuaishouTokenVo.setRefreshExpireTime(DateUtil.dateTo14String((Date)new Date(refreshExDate)));
                kuaishouTokenVo.setAdvertiserIds(advertiser_ids);
                kuaishouTokenVo.setSecret(secret);
                kuaishouTokenVo.setAppKey(appKey);
                this.updater.hupdate(RedisKeys.hashKuaishouToken(), appId, (Object)JsonHelper.convert((Object)kuaishouTokenVo));
                HashMap<String, String> multiUpdateMap = new HashMap<String, String>();
                for (Long advertiser_id : advertiser_ids) {
                    HashMap<String, String> valueMap = new HashMap<String, String>();
                    valueMap.put("accessToken", access_token);
                    valueMap.put("expire", exDateFormat);
                    multiUpdateMap.put(Objects.toString(advertiser_id), JSONObject.toJSONString(valueMap));
                }
                this.rtbJedisUpdater.hmupdate(RedisKeys.hashRtbKuaishouAccessToken((String)appKey), multiUpdateMap);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "\u6388\u6743\u5931\u8d25\uff1a\u7cfb\u7edf\u5f02\u5e38";
        }
        return "\u6388\u6743\u6210\u529f";
    }
}

