/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.third;

import com.bxm.adsmanager.model.ro.QttRo;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class QTTAndBXMController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(QTTAndBXMController.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    @RequestMapping(value={"/qttAndBxm/updateOrSave"}, produces={"application/json"})
    public ResultModel<Boolean> updateQtt(@RequestParam(value="ticketId") String ticketId, @RequestParam(value="planId") String planId, @RequestParam(value="type") String type) {
        ResultModel rs = new ResultModel();
        try {
            if (StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)type)) {
                this.updater.hupdateWithSelector(QTTAndBXMController.qttAndbxmPlanAndTicketId(), planId, (Object)ticketId, 11);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)type)) {
                this.updater.hremoveWithSelector(QTTAndBXMController.qttAndbxmPlanAndTicketId(), 11, new String[]{planId});
            }
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/qttAndBxm/getListQtt"}, produces={"application/json"})
    public ResultModel<List<QttRo>> getList(String ticketId) {
        ResultModel rs = new ResultModel();
        try {
            ArrayList<QttRo> list = new ArrayList<QttRo>();
            Map mapConfigAll = this.fetcher.hfetchallWithSelector(QTTAndBXMController.qttAndbxmPlanAndTicketId(), String.class, 11);
            if (mapConfigAll != null) {
                for (String planId : mapConfigAll.keySet()) {
                    QttRo qttRo = new QttRo();
                    qttRo.setTicketId((String)mapConfigAll.get(planId));
                    if (StringUtils.isNotBlank((CharSequence)ticketId) && !StringUtils.equalsIgnoreCase((CharSequence)ticketId, (CharSequence)qttRo.getTicketId())) continue;
                    qttRo.setPlanId(planId);
                    list.add(qttRo);
                }
            }
            rs.setReturnValue(list);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    public static KeyGenerator qttAndbxmPlanAndTicketId() {
        return () -> KeyBuilder.build((Object[])new Object[]{"qtt", "and", "bxm", "planId", "ticketId"});
    }
}

