/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.weight;

import com.bxm.adsmanager.model.dto.TicketArpuDTO;
import com.bxm.adsmanager.model.vo.AdTicketArpuVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketArpuService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adTicketArpu"})
public class AdTicketArpuController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketArpuController.class);
    @Autowired
    AdTicketArpuService adTicketArpuService;

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<AdTicketArpuVo>> findTicketByParams(TicketArpuDTO ticketArpuDTO) {
        try {
            ResultModel rs = new ResultModel();
            PageInfo pageInfo = this.adTicketArpuService.findAll(ticketArpuDTO);
            rs.setReturnValue((Object)pageInfo);
            return rs;
        }
        catch (ValidateException v) {
            LOGGER.error(v.getMessage(), (Throwable)v);
            return ResultModelFactory.FAIL400((String)v.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u5238appu\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u5e7f\u544a\u5238arpu\u51fa\u9519");
        }
    }

    @LogBefore(operType="/adTicketArpu/add", keyName="\u6dfb\u52a0arpu")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel add(TicketArpuDTO ticketArpuDTO) {
        try {
            this.adTicketArpuService.add(ticketArpuDTO);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (ValidateException v) {
            LOGGER.error(v.getMessage(), (Throwable)v);
            return ResultModelFactory.FAIL400((String)v.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u5e7f\u544a\u5238appu\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @LogBefore(operType="/adTicketArpu/update", keyName="\u4fee\u6539arpu")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResultModel update(TicketArpuDTO ticketArpuDTO) {
        try {
            this.adTicketArpuService.update(ticketArpuDTO);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (ValidateException v) {
            LOGGER.error(v.getMessage(), (Throwable)v);
            return ResultModelFactory.FAIL400((String)v.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u5e7f\u544a\u5238appu\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @LogBefore(operType="/adTicketArpu/delete", keyName="\u5220\u9664arpu")
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public ResultModel delete(Integer id) {
        try {
            this.adTicketArpuService.delete(id);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (ValidateException v) {
            LOGGER.error(v.getMessage(), (Throwable)v);
            return ResultModelFactory.FAIL400((String)v.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5e7f\u544a\u5238appu\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }
}

