/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.weight;

import com.bxm.acl.facade.model.UserRo;
import com.bxm.adsmanager.integration.acl.impl.AclUserIntegrationImpl;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.AdTicketCopyVo;
import com.bxm.adsmanager.model.vo.AdTicketWeightVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adTicket"})
public class AdTicketWeightController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(AdTicketWeightController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketWeightController.class);
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AclUserIntegrationImpl aclUserIntegration;

    @RequestMapping(value={"/queryAllAdvertiser"}, method={RequestMethod.GET})
    public ResultModel<Map<Integer, String>> queryAllAdvertiser(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            Map allAdvertiserMap = this.adShopIntegration.getAllAdvertiserMap();
            rs.setReturnValue((Object)allAdvertiserMap);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5e7f\u544a\u4e3b\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
        return rs;
    }

    @RequestMapping(value={"/queryTicketByAdvertiser"}, method={RequestMethod.GET})
    public ResultModel<List<AdTicketCopyVo>> queryTicketByAdvertiser(@RequestParam(value="advertiserId", required=false) Integer advertiserId, @RequestParam(value="ticketId", required=false) Integer ticketId, @RequestParam(value="ae", required=false) String ae, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        UserRo userRo = this.aclUserIntegration.queryUserByUsername(ae);
        if (null != userRo && StringUtils.isNotBlank((CharSequence)userRo.getRoleName()) && userRo.getRoleName().contains(RoleEnum.AELEADER.getName())) {
            ae = null;
        }
        try {
            List ticketByAdvertiser = this.adTicketService.getTicketByAdvertiser(advertiserId, ticketId, ae);
            rs.setReturnValue((Object)ticketByAdvertiser);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5e7f\u544a\u5238\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
        return rs;
    }

    @RequestMapping(value={"/queryTicketsByCondition"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<AdTicketWeightVo>> queryTicketsByNameOrId(AdTicketSearchDto adTicketSearchDto, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            PageInfo adTicketWeightVoPage = this.adTicketService.queryTicketsByCondition(adTicketSearchDto);
            rs.setReturnValue((Object)adTicketWeightVoPage);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5e7f\u544a\u5238\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            ResultModelFactory.FAIL();
        }
        return rs;
    }

    @RequestMapping(value={"/queryAdvertiserByCondition"}, method={RequestMethod.GET})
    public ResultModel<List<AdTicketWeightVo>> queryAdvertiserByCondition(@RequestParam(value="ae", required=false) String ae, @RequestParam(value="advertiserId", required=false) Integer advertiserId, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            List adTicketWeightVos = this.adTicketService.queryAdvertiserByCondition(ae, advertiserId);
            rs.setReturnValue((Object)adTicketWeightVos);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5e7f\u544a\u4e3b\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            ResultModelFactory.FAIL();
        }
        return rs;
    }

    @RequestMapping(value={"/getAllAe"}, method={RequestMethod.GET})
    public ResultModel<List<AdTicketWeightVo>> getAllAe(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            List adTicketWeightVos = this.adTicketService.getAllAe();
            rs.setReturnValue((Object)adTicketWeightVos);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5e7f\u544a\u4e3b\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            ResultModelFactory.FAIL();
        }
        return rs;
    }

    @LogBefore(operType="/adTicket/updateInterventionFactor", keyName="\u6743\u91cd")
    @RequestMapping(value={"/updateInterventionFactor"}, method={RequestMethod.POST})
    public ResultModel<Boolean> updateInterventionFactor(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ticketId", required=true) Integer ticketId, @RequestParam(value="interventionFactor", required=true) Double interventionFactor) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            String userName = this.getUser(request, response).getUsername();
            rs.setReturnValue((Object)this.adTicketService.updateInterventionFactor(ticketId, interventionFactor, userName));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u6743\u91cd\u51fa\u9519" + e.getMessage(), (Throwable)e);
            ResultModelFactory.FAIL();
        }
        return rs;
    }
}

