/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.ydticket;

import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class YDTicketController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(YDTicketController.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    @RequestMapping(value={"/yd/addOrUpdate"}, produces={"application/json"})
    public ResultModel<Boolean> updateQtt(@RequestParam(value="ticketIds", required=false) String ticketIds) {
        ResultModel rs = new ResultModel();
        try {
            this.updater.update(YDTicketController.getAllYDTicketIds(), (Object)ticketIds);
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/yd/getAll"}, produces={"application/json"})
    public ResultModel<String> getList() {
        ResultModel rs = new ResultModel();
        try {
            String value = (String)this.fetcher.fetch(YDTicketController.getAllYDTicketIds(), String.class);
            rs.setReturnValue((Object)value);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    public static KeyGenerator getAllYDTicketIds() {
        return () -> KeyBuilder.build((Object[])new Object[]{"API", "YD", "TICKETIDS"});
    }
}

