package com.bxm.pangu.rta.common;

import java.util.Map;
import java.util.function.Consumer;

/**
 * RTA 查询客户端
 *
 * @author allen
 * @date 2021-12-20
 * @since 1.0.0
 */
public interface RtaClient {

    /**
     * 返回这个客户端的RTA类型
     *
     * @return RTA类型
     */
    RtaType getRtaType();

    /**
     * 返回这个客户端的协议格式
     * @return 默认：json
     */
    default ProtocolFormat getProtocolFormat() {
        return ProtocolFormat.Json;
    }

    /**
     * 是否命中
     *
     * @param request 请求对象
     * @return 是否目标用户，如果返回 true 即表示投放。
     * @throws RtaRequestException RTA请求异常，比如网络异常、响应异常等。
     */
    default boolean isTarget(RtaRequest request) throws RtaRequestException {
        return isTarget(request, null);
    }

    /**
     * 是否命中
     * @param request 请求对象
     * @param feedback 命中后的回调
     * @return 是否目标用户，如果返回 true 即表示投放。
     * @throws RtaRequestException RTA请求异常，比如网络异常、响应异常等。
     */
    boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException;
}
