/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.getui;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.getui.GetuiRequest;
import com.bxm.pangu.rta.common.getui.GetuiResponse;
import com.bxm.pangu.rta.common.getui.GetuiRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UUIDHelper;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;

public class GetuiRtaClient
extends AbstractHttpClientRtaClient {
    private final GetuiRtaProperties properties;

    public GetuiRtaClient(GetuiRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        HttpPost post = new HttpPost(this.properties.getUrl());
        String timeStamp = TypeHelper.castToString((Object)System.currentTimeMillis());
        post.addHeader("appKey", this.properties.getAppKey());
        post.addHeader("timeStamp", timeStamp);
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.addHeader("token", DigestUtils.md5Hex((String)(this.properties.getAppKey() + this.properties.getAppSecret() + timeStamp)));
        int adsType = NumberUtils.toInt((String)this.properties.getAdsType());
        int targetType = NumberUtils.toInt((String)this.properties.getTargetType());
        String param = request.getParam();
        if (StringUtils.isNotBlank((String)param)) {
            String[] arr = StringUtils.split((String)param, (String)"-");
            adsType = NumberUtils.toInt((String)arr[0], (int)adsType);
            if (arr.length >= 2) {
                targetType = NumberUtils.toInt((String)arr[1], (int)targetType);
            }
        }
        GetuiRequest.Device dev = new GetuiRequest.Device().setImei(request.getImei()).setImeiMd5(request.getImei_md5()).setOaid(request.getOaid()).setOaidMd5(request.getOaid_md5()).setIdfa(request.getIdfa()).setIdfaMd5(request.getIdfa_md5()).setAndroidId(request.getAndroidid()).setAndroidIdMd5(request.getAndroidid_md5());
        GetuiRequest.Condition condition = new GetuiRequest.Condition().setAdsType(adsType).setTargetType(targetType);
        GetuiRequest gt = new GetuiRequest().setRequestId(UUIDHelper.generate()).setDevice(dev).setQueryConditions(Lists.newArrayList((Object[])new GetuiRequest.Condition[]{condition}));
        post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)gt), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        GetuiResponse response = (GetuiResponse)JsonHelper.convert((String)json, GetuiResponse.class);
        if (!response.isRequestOk()) {
            return false;
        }
        List<GetuiResponse.Data> data = response.getData();
        return CollectionUtils.isNotEmpty(data) && data.get(0).getResult() == 1;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Getui;
    }
}

