/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.oneway;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.oneway.OneWayRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;

public class OneWayRtaClient
extends AbstractHttpClientRtaClient {
    private final OneWayRtaProperties properties;

    public OneWayRtaClient(OneWayRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.OneWay;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String os = request.getOs();
        String platform = StringUtils.equals((String)os, (String)"android") ? "1" : (StringUtils.equals((String)os, (String)"ios") ? "2" : "0");
        String product = Optional.ofNullable(request.getParam()).orElse("");
        HashMap params = Maps.newHashMap();
        params.put("channel", this.properties.getChannel());
        params.put("product", product);
        params.put("imeiMd5", request.getImei_md5());
        params.put("oaid", request.getOaid());
        params.put("oaidMd5", request.getOaid_md5());
        params.put("idfa", request.getIdfa());
        params.put("idfaMd5", request.getIdfa_md5());
        params.put("platform", platform);
        HttpPost post = new HttpPost(this.properties.getUrl());
        String entity = JsonHelper.convert((Object)params);
        post.setEntity((HttpEntity)new StringEntity(entity, StandardCharsets.UTF_8));
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.addHeader("Accept-Encoding", "gzip");
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        Matched matched = (Matched)JsonHelper.convert((String)json, Matched.class);
        return matched.isTarget();
    }

    private static class MatchedData {
        private boolean isTarget;

        public boolean isTarget() {
            return this.isTarget;
        }

        public void setTarget(boolean isTarget) {
            this.isTarget = isTarget;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchedData)) {
                return false;
            }
            MatchedData other = (MatchedData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isTarget() == other.isTarget();
        }

        protected boolean canEqual(Object other) {
            return other instanceof MatchedData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isTarget() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "OneWayRtaClient.MatchedData(isTarget=" + this.isTarget() + ")";
        }
    }

    private static class Matched {
        private int code;
        private boolean success;
        private String message;
        private MatchedData data;

        boolean isTarget() {
            return Objects.nonNull(this.data) && this.data.isTarget();
        }

        public int getCode() {
            return this.code;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public MatchedData getData() {
            return this.data;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setData(MatchedData data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Matched)) {
                return false;
            }
            Matched other = (Matched)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            MatchedData this$data = this.getData();
            MatchedData other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Matched;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            MatchedData $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "OneWayRtaClient.Matched(code=" + this.getCode() + ", success=" + this.isSuccess() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
        }
    }
}

