/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.taobao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.taobao.TaobaoRtaProperties;
import com.google.common.collect.Maps;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.request.UsergrowthDhhDeliveryAskRequest;
import com.taobao.api.response.UsergrowthDhhDeliveryAskResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaobaoRtaClient
implements RtaClient {
    private static final Logger log = LoggerFactory.getLogger(TaobaoRtaClient.class);
    private final TaobaoRtaProperties properties;
    private final TaobaoClient client;

    public TaobaoRtaClient(TaobaoRtaProperties properties) {
        this.properties = properties;
        String url = properties.getUrl();
        String appKey = properties.getAppKey();
        String appSecret = properties.getAppSecret();
        int connectTimeout = properties.getConnectTimeout();
        int socketTimeout = properties.getSocketTimeout();
        TaobaoLogger.setNeedEnableLogger((boolean)properties.isNeedEnableLogger());
        this.client = new DefaultTaobaoClient(url, appKey, appSecret, "json", connectTimeout, socketTimeout);
    }

    @Override
    public boolean isTarget(RtaRequest req, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        String oaidMd5;
        String oaid;
        String idfaMd5;
        String idfa;
        String imeiMd5;
        UsergrowthDhhDeliveryAskRequest request = new UsergrowthDhhDeliveryAskRequest();
        if (StringUtils.equals((String)req.getOs(), (String)"android")) {
            request.setOs("0");
        } else if (StringUtils.equals((String)req.getOs(), (String)"ios")) {
            request.setOs("1");
        } else {
            request.setOs("3");
        }
        String imei = req.getImei();
        if (StringUtils.isNotBlank((String)imei)) {
            request.setImei(imei);
        }
        if (StringUtils.isNotBlank((String)(imeiMd5 = req.getImei_md5()))) {
            request.setImeiMd5(imeiMd5);
        }
        if (StringUtils.isNotBlank((String)(idfa = req.getIdfa()))) {
            request.setIdfa(idfa);
        }
        if (StringUtils.isNotBlank((String)(idfaMd5 = req.getIdfa_md5()))) {
            request.setIdfaMd5(idfaMd5);
        }
        if (StringUtils.isNotBlank((String)(oaid = req.getOaid()))) {
            request.setOaid(oaid);
        }
        if (StringUtils.isNotBlank((String)(oaidMd5 = req.getOaid_md5()))) {
            request.setOaidMd5(oaidMd5);
        }
        String channel = this.properties.getChannel();
        String advertisingSpaceId = this.properties.getAdvertisingSpaceId();
        String targetTaskId = null;
        String param = req.getParam();
        if (StringUtils.isNotBlank((String)param)) {
            String[] params = StringUtils.splitPreserveAllTokens((String)param, (String)"|");
            channel = StringUtils.defaultIfBlank((String)params[0], (String)this.properties.getChannel());
            if (params.length > 1) {
                advertisingSpaceId = StringUtils.defaultIfBlank((String)params[1], (String)this.properties.getAdvertisingSpaceId());
            }
            if (params.length > 2) {
                targetTaskId = params[2];
            }
        }
        request.setChannel(channel);
        request.setAdvertisingSpaceId(advertisingSpaceId);
        try {
            boolean isTarget;
            boolean hitTarget;
            UsergrowthDhhDeliveryAskResponse response = (UsergrowthDhhDeliveryAskResponse)this.client.execute((TaobaoRequest)request);
            if (Objects.isNull(response)) {
                if (log.isInfoEnabled() && RandomUtils.nextInt((int)99) == 0) {
                    log.info("Taobao rta response is empty!");
                }
                return false;
            }
            String body = response.getBody();
            if (log.isDebugEnabled()) {
                log.debug("response: {}", (Object)body);
            }
            if (!(hitTarget = Optional.ofNullable(response.getResult()).orElse(false).booleanValue())) {
                return false;
            }
            JSONObject json = JSONObject.parseObject((String)body);
            JSONObject usergrowthDhhDeliveryAskResponse = json.getJSONObject("usergrowth_dhh_delivery_ask_response");
            if (MapUtils.isEmpty((Map)usergrowthDhhDeliveryAskResponse)) {
                return false;
            }
            JSONObject taskIdListNode = usergrowthDhhDeliveryAskResponse.getJSONObject("task_id_list");
            if (MapUtils.isEmpty((Map)taskIdListNode)) {
                return false;
            }
            JSONArray taskIdListJsonArray = taskIdListNode.getJSONArray("string");
            Set taskIdList = taskIdListJsonArray.stream().map(new Function<Object, String>(){

                @Override
                public String apply(Object object) {
                    return Objects.toString(object);
                }
            }).collect(Collectors.toSet());
            String taskId = response.getTaskId();
            if (StringUtils.isNotBlank((String)targetTaskId) && !taskIdList.contains(targetTaskId)) {
                return false;
            }
            HashMap res = Maps.newHashMap();
            res.put("channel", channel);
            res.put("advertisingSpaceId", advertisingSpaceId);
            res.put("taskId", taskId);
            res.put("taskIdList", taskIdList);
            res.put("device", req);
            Function<Map<Object, Object>, Boolean> targetHandler = this.properties.getTargetHandler();
            boolean bl = isTarget = Objects.nonNull(targetHandler) ? targetHandler.apply(res) : true;
            if (isTarget && Objects.nonNull(feedback)) {
                feedback.accept(res);
            }
            return isTarget;
        }
        catch (ApiException e) {
            log.warn("{}", (Object)e.getMessage());
            throw new RtaRequestException(e);
        }
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Taobao;
    }
}

