/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.TargetFactory;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.RandomUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

@Aspect
public class CachingAspect {
    private static final Logger log = LoggerFactory.getLogger(CachingAspect.class);
    private final Fetcher fetcher;
    private final Set<String> enable;

    public CachingAspect(Fetcher fetcher, Set<String> enable) {
        this.fetcher = fetcher;
        this.enable = enable;
    }

    @Pointcut(value="this(com.bxm.pangu.rta.common.RtaClient) && execution(* isTarget(..))")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(final ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof RtaClient)) {
            return point.proceed();
        }
        Object[] args = point.getArgs();
        if (ArrayUtils.isEmpty((Object[])args)) {
            return point.proceed();
        }
        Object arg = args[0];
        if (!(arg instanceof RtaRequest)) {
            return point.proceed();
        }
        final RtaRequest request = (RtaRequest)arg;
        final RtaClient client = (RtaClient)target;
        if (!this.enable.contains(ClassUtils.getUserClass((Object)client).getName())) {
            return point.proceed();
        }
        return this.fetcher.fetch(new TargetFactory().keyGenerator(new KeyGenerator(){

            public String generateKey() {
                String simple = ToStringBuilder.reflectionToString((Object)request, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
                String key = KeyBuilder.build((Object[])new Object[]{"RTA", "CACHE", client.getRtaType().getType(), DigestUtils.md5Hex((String)simple)});
                if (log.isDebugEnabled()) {
                    log.debug("{}", (Object)key);
                }
                return key;
            }
        }).cls(Boolean.class).expireTimeInSecond((int)DateHelper.getRemainSecondsOfToday() + RandomUtils.nextInt((int)60)).dataExtractor((DataExtractor)new DataExtractor<Boolean>(){

            public Boolean extract() {
                try {
                    return (boolean)((Boolean)point.proceed());
                }
                catch (Throwable throwable) {
                    return false;
                }
            }
        }).build());
    }
}

