/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.meituan;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.ProtocolFormat;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.meituan.MeituanRtaProperties;
import com.bxm.pangu.rta.common.meituan.MeituanRtaProtos;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeituanRtaClient
extends AbstractHttpClientRtaClient {
    private static final Logger log = LoggerFactory.getLogger(MeituanRtaClient.class);

    public MeituanRtaClient(MeituanRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        MeituanRtaProtos.RtaRequest.Builder builder = MeituanRtaProtos.RtaRequest.newBuilder();
        builder.setId(RandomStringUtils.randomAlphanumeric((int)8)).setIsPing(false).setIsTest(false);
        MeituanRtaProtos.RtaRequest.Device.Builder b1 = MeituanRtaProtos.RtaRequest.Device.newBuilder();
        if ("android".equalsIgnoreCase(request.getOs())) {
            b1.setOs(MeituanRtaProtos.RtaRequest.OperatingSystem.OS_ANDROID);
        } else if ("ios".equalsIgnoreCase(request.getOs())) {
            b1.setOs(MeituanRtaProtos.RtaRequest.OperatingSystem.OS_IOS);
        } else {
            b1.setOs(MeituanRtaProtos.RtaRequest.OperatingSystem.OS_UNKNOWN);
        }
        if (StringUtils.isNotBlank((String)request.getImei_md5())) {
            b1.setImeiMd5Sum(request.getImei_md5());
        }
        if (StringUtils.isNotBlank((String)request.getIdfa_md5())) {
            b1.setIdfaMd5Sum(request.getIdfa_md5());
        }
        if (StringUtils.isNotBlank((String)request.getAndroidid_md5())) {
            b1.setAndroidIdMd5Sum(request.getAndroidid_md5());
        }
        if (StringUtils.isNotBlank((String)request.getOaid_md5())) {
            b1.setOaidMd5Sum(request.getOaid_md5());
        }
        if (StringUtils.isNotBlank((String)request.getOaid())) {
            b1.setOaid(request.getOaid());
        }
        builder.setDevice(b1.build());
        String param = request.getParam();
        if (StringUtils.isBlank((String)param)) {
            throw new RtaRequestException("param");
        }
        String[] arr = StringUtils.split((String)param, (String)"|");
        builder.setSiteId(arr[0]);
        MeituanRtaProtos.RtaRequest req = builder.build();
        HttpPost post = new HttpPost(this.getProperties().getUrl());
        post.addHeader("Content-Type", "application/x-protobuf;charset=UTF-8");
        post.setEntity((HttpEntity)new ByteArrayEntity(req.toByteArray()));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, byte[] bytes) {
        try {
            String param;
            String[] arr;
            MeituanRtaProtos.RtaResponse response = MeituanRtaProtos.RtaResponse.parseFrom(bytes);
            int code = response.getCode();
            List<Long> targetIdList = response.getPromotionTargetIdList();
            if (log.isDebugEnabled()) {
                log.debug("target: {}", targetIdList);
            }
            if ((arr = StringUtils.splitPreserveAllTokens((String)(param = request.getParam()), (String)"|")).length < 2) {
                throw new RtaRequestException("param value length must >= 2");
            }
            return 0 == code && targetIdList.contains(NumberUtils.toLong((String)arr[1]));
        }
        catch (InvalidProtocolBufferException e) {
            log.warn("parseFrom: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Meituan;
    }

    @Override
    public ProtocolFormat getProtocolFormat() {
        return ProtocolFormat.Protobuf;
    }
}

