package com.bxm.pangu.rta.common.douyu;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.springframework.http.MediaType;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author allen
 * @date 2022-03-29
 * @since 1.0
 */
public class DouyuRtaClient extends AbstractHttpClientRtaClient {

    public DouyuRtaClient(DouyuRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        HttpPost post = new HttpPost(getProperties().getUrl());
        post.addHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_UTF8_VALUE);

        String oaidMd5 = request.getOaid_md5();
        if (StringUtils.isBlank(oaidMd5)) {
            throw new RtaRequestException("Only supported oaid_md5");
        }
        List<String> uids = Lists.newArrayList(oaidMd5);
        String utype = "oaid";
        String encrypttype = "md5";

        Map<String, Object> map = new HashMap<>();
        map.put("uids", uids);
        map.put("utype", utype);
        map.put("encrypttype", encrypttype);

        post.setEntity(new ByteArrayEntity(JsonHelper.convert2bytes(map)));

        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return JsonHelper.convert(json, Res.class).isTarget(request);
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Douyu;
    }

    @Data
    private static class Res {

        private String code;
        private String msg;
        private List<String> uids;

        public boolean isTarget(RtaRequest request) {
            return StringUtils.equals("1", code) && CollectionUtils.isNotEmpty(uids) && uids.contains(request.getOaid_md5());
        }
    }
}
