/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common;

import com.alibaba.fastjson.JSONException;
import com.bxm.pangu.rta.common.AbstractRtaProperties;
import com.bxm.pangu.rta.common.ProtocolFormat;
import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.utils.HttpClientUtils;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClientRtaClient
implements RtaClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpClientRtaClient.class);
    private final HttpClient httpClient;
    private final AbstractRtaProperties properties;

    public AbstractHttpClientRtaClient(AbstractRtaProperties properties) {
        this.properties = properties;
        int maxTotal = properties.getMaxTotal();
        int defaultMaxPerRoute = properties.getDefaultMaxPerRoute();
        int connectionRequestTimeout = properties.getConnectionRequestTimeout();
        int connectTimeout = properties.getConnectTimeout();
        int socketTimeout = properties.getSocketTimeout();
        this.httpClient = HttpClientUtils.createHttpClient(maxTotal, defaultMaxPerRoute, connectionRequestTimeout, connectTimeout, socketTimeout);
    }

    protected abstract HttpRequestBase create(RtaRequest var1);

    protected abstract boolean isTarget(RtaRequest var1, String var2);

    protected boolean isTarget(RtaRequest request, byte[] bytes) {
        return false;
    }

    @Override
    public boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        String body = null;
        HttpRequestBase requestBase = null;
        RtaType rtaType = this.getRtaType();
        try {
            boolean isTarget;
            HttpResponse response;
            int statusCode;
            requestBase = this.create(request);
            if (log.isDebugEnabled()) {
                log.debug("request: {}", (Object)requestBase.getURI());
            }
            if ((statusCode = (response = this.httpClient.execute((HttpUriRequest)requestBase)).getStatusLine().getStatusCode()) != 200) {
                log.warn("{} - statusCode: {}", (Object)rtaType, (Object)statusCode);
            }
            ProtocolFormat format = this.getProtocolFormat();
            switch (format) {
                case Protobuf: {
                    byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                    isTarget = this.isTarget(request, bytes);
                    break;
                }
                default: {
                    body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    if (log.isDebugEnabled()) {
                        log.debug("response: {}", (Object)body);
                    }
                    isTarget = this.isTarget(request, body);
                }
            }
            if (isTarget && Objects.nonNull(feedback)) {
                feedback.accept(Maps.newHashMap());
            }
            boolean bl = isTarget;
            return bl;
        }
        catch (JSONException e) {
            if (this.properties.isPrintException()) {
                log.warn("{} - {} - {}", new Object[]{rtaType, e.getMessage(), body});
            }
            throw new RtaRequestException(e);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("{} - {}", (Object)rtaType, (Object)e.getMessage());
            }
            throw new RtaRequestException(e);
        }
        finally {
            if (Objects.nonNull(requestBase) && !requestBase.isAborted()) {
                requestBase.abort();
            }
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public AbstractRtaProperties getProperties() {
        return this.properties;
    }
}

