/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.core;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaClientProperties;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.core.RequestEvent;
import com.bxm.warcar.MessageException;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestComputeTimesEventListener
implements EventListener<RequestEvent> {
    private static final Logger log = LoggerFactory.getLogger(RequestComputeTimesEventListener.class);
    private final Counter counter;
    private final MessageSender messageSender;

    public RequestComputeTimesEventListener(Counter counter, MessageSender messageSender) {
        this.counter = counter;
        this.messageSender = messageSender;
    }

    @Subscribe
    public void consume(RequestEvent event) {
        RtaClient rtaClient = event.getRtaClient();
        RtaRequest rtaRequest = event.getRtaRequest();
        String field = rtaClient.getRtaType().getType() + "-" + rtaClient.getIdentifyForCounter(rtaRequest);
        RtaClientProperties properties = rtaClient.getProperties();
        if (Objects.isNull(properties)) {
            return;
        }
        List<Long> requestTimesForWarning = properties.getRequestTimesForWarning();
        if (CollectionUtils.isEmpty(requestTimesForWarning)) {
            return;
        }
        long times = Optional.ofNullable(this.counter.hincrementAndGet(() -> KeyBuilder.build((Object[])new Object[]{"RTA", "REQUESTS_TIMES", DateHelper.getDate()}), field, 86400)).orElse(1L);
        requestTimesForWarning.sort(new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return Long.compare(o2, o1);
            }
        });
        for (Long t : requestTimesForWarning) {
            if (times < t || !this.isSendIfNecessary(field, t)) continue;
            this.sendMessage(rtaClient.getRtaType().name(), properties, times);
            break;
        }
    }

    private void sendMessage(String rtaName, RtaClientProperties properties, long times) {
        Message message = new Message();
        message.setContent(String.format("[RTA-Helper] %s \u5f53\u524d\u8bf7\u6c42\u6b21\u6570\u5df2\u8fbe\u5230 %s \u6b21\u3002\n\u81ea\u5b9a\u4e49\u914d\u7f6e=%s", rtaName, times, properties.toSimpleString()));
        try {
            log.info("rta-request-warning: {}", (Object)message.getContent());
            this.messageSender.send2(message);
        }
        catch (MessageException e) {
            log.error("send2: ", (Throwable)e);
        }
    }

    private boolean isSendIfNecessary(String field, long t) {
        Long notifiedTimes = Optional.ofNullable(this.counter.hincrementAndGet(() -> KeyBuilder.build((Object[])new Object[]{"RTA", "REQUESTS_NOTIFIED", DateHelper.getDate(), field}), TypeHelper.castToString((Object)t), 86400)).orElse(1L);
        return notifiedTimes <= 3L;
    }
}

