/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.oneway;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.oneway.OneWayRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;

public class OneWayRtaClient
extends AbstractHttpClientRtaClient {
    private final OneWayRtaProperties properties;

    public OneWayRtaClient(OneWayRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.OneWay;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String os = request.getOs();
        String platform = StringUtils.equals((String)os, (String)"android") ? "1" : (StringUtils.equals((String)os, (String)"ios") ? "2" : "0");
        String param = request.getParam();
        String[] arr = this.split(param);
        String[] ids = StringUtils.split((String)arr[1], (String)",");
        HashMap params = Maps.newHashMap();
        params.put("channel", arr[0]);
        params.put("offerIds", ids);
        params.put("imeiMd5", request.getImei_md5());
        params.put("oaid", request.getOaid());
        params.put("oaidMd5", request.getOaid_md5());
        params.put("idfa", request.getIdfa());
        params.put("idfaMd5", request.getIdfa_md5());
        params.put("platform", platform);
        HttpPost post = new HttpPost(this.properties.getUrl());
        String entity = JsonHelper.convert((Object)params);
        post.setEntity((HttpEntity)new StringEntity(entity, StandardCharsets.UTF_8));
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.addHeader("Accept-Encoding", "gzip");
        return post;
    }

    private String[] split(String param) {
        if (StringUtils.isBlank((String)param)) {
            throw new RtaRequestException("param must be {channel}|{offerIds,offerIds}");
        }
        String[] arr = StringUtils.splitPreserveAllTokens((String)param, (String)"|");
        if (arr.length < 2) {
            throw new RtaRequestException("param must be {channel}|{offerIds,offerIds}");
        }
        return arr;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        Matched matched = (Matched)JsonHelper.convert((String)json, Matched.class);
        if (!matched.isSuccess()) {
            return false;
        }
        MatchedData data = matched.getData();
        if (Objects.isNull(data)) {
            return false;
        }
        final List<String> offerIds = data.getOfferIds();
        if (CollectionUtils.isEmpty(offerIds)) {
            return false;
        }
        String[] arr = this.split(request.getParam());
        ArrayList configOfferIds = Lists.newArrayList((Object[])StringUtils.split((String)arr[1], (String)","));
        return configOfferIds.stream().anyMatch(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return offerIds.contains(s);
            }
        });
    }

    private static class MatchedData {
        private List<String> offerIds;

        public List<String> getOfferIds() {
            return this.offerIds;
        }

        public void setOfferIds(List<String> offerIds) {
            this.offerIds = offerIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchedData)) {
                return false;
            }
            MatchedData other = (MatchedData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$offerIds = this.getOfferIds();
            List<String> other$offerIds = other.getOfferIds();
            return !(this$offerIds == null ? other$offerIds != null : !((Object)this$offerIds).equals(other$offerIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MatchedData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $offerIds = this.getOfferIds();
            result = result * 59 + ($offerIds == null ? 43 : ((Object)$offerIds).hashCode());
            return result;
        }

        public String toString() {
            return "OneWayRtaClient.MatchedData(offerIds=" + this.getOfferIds() + ")";
        }
    }

    private static class Matched {
        private int code;
        private boolean success;
        private String message;
        private MatchedData data;

        public int getCode() {
            return this.code;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public MatchedData getData() {
            return this.data;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setData(MatchedData data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Matched)) {
                return false;
            }
            Matched other = (Matched)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            MatchedData this$data = this.getData();
            MatchedData other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Matched;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            MatchedData $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "OneWayRtaClient.Matched(code=" + this.getCode() + ", success=" + this.isSuccess() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
        }
    }
}

