/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.tencent;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.ProtocolFormat;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.tencent.TencentVideoRtaProperties;
import com.bxm.pangu.rta.common.tencent.TencentVideoRtaProtos;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Optional;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentVideoRtaClient
extends AbstractHttpClientRtaClient {
    private static final Logger log = LoggerFactory.getLogger(TencentVideoRtaClient.class);
    private final TencentVideoRtaProperties properties;

    public TencentVideoRtaClient(TencentVideoRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        TencentVideoRtaProtos.RtaRequest.Builder builder = TencentVideoRtaProtos.RtaRequest.newBuilder();
        builder.setId(RandomStringUtils.randomAlphanumeric((int)8));
        builder.setChannel(Optional.ofNullable(request.getParam()).orElse(this.properties.getChannel()));
        if (StringUtils.isNotBlank((String)request.getImei_md5())) {
            builder.setImeiMd5Sum(request.getImei_md5());
        }
        if (StringUtils.isNotBlank((String)request.getOaid())) {
            builder.setOaid(request.getOaid());
        }
        HttpPost post = new HttpPost(this.properties.getUrl());
        post.addHeader("Content-Type", "application/x-protobuf;charset=UTF-8");
        post.setEntity((HttpEntity)new ByteArrayEntity(builder.build().toByteArray()));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProtocolFormat getProtocolFormat() {
        return ProtocolFormat.Protobuf;
    }

    @Override
    protected boolean isTarget(RtaRequest request, byte[] bytes) {
        try {
            TencentVideoRtaProtos.RtaResponse response = TencentVideoRtaProtos.RtaResponse.parseFrom(bytes);
            return response.getCode() == 0;
        }
        catch (InvalidProtocolBufferException e) {
            log.error("isTarget: ", (Throwable)e);
            return false;
        }
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.TencentVideo;
    }
}

