/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.autoconfigure;

import com.bxm.pangu.rta.common.CachingAspect;
import com.bxm.pangu.rta.common.CachingRedisProperties;
import com.bxm.pangu.rta.common.micrometer.RtaClientMicroMeter;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.fetchers.RedisFetcher;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

@EnableConfigurationProperties(value={CachingRedisProperties.class})
public class CachingAutoConfiguration {
    private final CachingRedisProperties properties;

    public CachingAutoConfiguration(CachingRedisProperties properties) {
        this.properties = properties;
    }

    @Bean(name={"cachingJedisPool"})
    public JedisPool cachingJedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.properties, this.properties.getHost(), this.properties.getPort(), this.properties.getTimeout(), this.properties.getPassword(), this.properties.getDatabase());
    }

    @Bean(name={"cachingFetcher"})
    public Fetcher cachingFetcher(@Qualifier(value="cachingJedisPool") JedisPool cachingJedisPool) {
        return new RedisFetcher(cachingJedisPool);
    }

    @Bean(name={"cachingCounter"})
    public Counter cachingCounter(@Qualifier(value="cachingJedisPool") JedisPool cachingJedisPool) {
        return new JedisCounter(cachingJedisPool);
    }

    @Bean
    public CachingAspect cachingAspect(@Qualifier(value="cachingFetcher") Fetcher fetcher, EventPark eventPark, RtaClientMicroMeter meter) {
        return new CachingAspect(fetcher, this.properties.getEnableRtaClient(), eventPark, meter);
    }
}

