package com.bxm.pangu.rta.common;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author allen
 * @date 2021-12-20
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class RtaRequest {

    /**
     * 自定义参数配置，请根据不同 RTA 类型来约定。
     */
    private String param;

    /**
     * 操作系统
     * @see Os
     */
    private String os;

    /**
     * imei
     */
    private String imei;
    private String imei_md5;
    /**
     * idfa
     */
    private String idfa;
    private String idfa_md5;
    /**
     * AndroidId
     */
    private String androidid;
    private String androidid_md5;
    /**
     * OAID
     */
    private String oaid;
    private String oaid_md5;
    /**
     * Google Advertising ID,谷歌广告标识码
     */
    private String gaid;
    private String gaid_md5;

    /**
     * 国家代码 如：CN
     */
    private String countryCode;

    /**
     * 根据媒体不同用这个字段区分特殊返回类型
     */
    private String type;

    /**
     * 自定义扩展参数
     */
    private String ext;

    public interface Os {

        // 请使用小写来定义 //

        /**
         * Android
         */
        String ANDROID = "android";

        /**
         * iOS
         */
        String IOS = "ios";

        /**
         * 鸿蒙
         */
        String HARMONY = "harmony";

        /**
         * Web
         */
        String WEB = "web";

        /**
         * 其他
         */
        String OTHER = "other";
    }
}
