package com.bxm.pangu.rta.common.vlion;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.List;

/**
 * 瑞狮网络
 *
 * 支持的配置参数：{app:alipay}|{targetTaskId:L00016}
 *
 * @author allen
 * @date 2021-12-30
 * @since 1.0
 */
public class VlionRtaClient extends AbstractHttpClientRtaClient {

    public VlionRtaClient(VlionRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = getProperties().getUrl();

        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();

        boolean flag = putIfNotBlank(params, "imei", request.getImei()) ||
                       putIfNotBlank(params, "imei_md5", request.getImei_md5()) ||
                       putIfNotBlank(params, "oaid", request.getOaid()) ||
                       putIfNotBlank(params, "oaid_md5", request.getOaid_md5()) ||
                       putIfNotBlank(params, "idfa", request.getIdfa()) ||
                       putIfNotBlank(params, "idfa_md5", request.getIdfa_md5());

        if (!flag) {
            throw new RtaRequestException("Empty device id.");
        }

        String appConfig = null;
        String param = request.getParam();
        if (StringUtils.isNotBlank(param)) {
            String[] arr = split(param);
            appConfig = arr[0];
        }

        String app = StringUtils.defaultIfBlank(appConfig, "alipay");
        params.set("app", app);

        String finalUrl = UriComponentsBuilder.fromUriString(url).replaceQueryParams(params).build().toString();

        return new HttpGet(finalUrl);
    }

    private String[] split(String param) {
        return StringUtils.split(param, "|");
    }

    private boolean putIfNotBlank(MultiValueMap<String, String> params, String name, String value) {
        if (StringUtils.isNotBlank(value)) {
            params.set("dp", name);
            params.set("d", value);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        VlionResponse response = JsonHelper.convert(json, VlionResponse.class);
        if (!response.isSuccess()) {
            return false;
        }
        List<VlionResponse.Item> data = response.getData();
        if (CollectionUtils.isEmpty(data)) {
            return false;
        }

        String taskId = null;
        String param = request.getParam();
        if (StringUtils.isNotBlank(param)) {
            String[] arr = split(param);
            if (arr.length >= 2) {
                taskId = arr[1];
            }
        }

        String finalTaskId = StringUtils.defaultIfBlank(taskId, "L00016");
        long count = data.stream().filter(e -> e.getDeviceLabel().contains(finalTaskId)).count();
        return count > 0;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Vlion;
    }
}
