/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.micrometer.RtaClientMicroMeter;
import com.bxm.pangu.rta.common.utils.MurmursUtils;
import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.TargetFactory;
import java.time.Duration;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.RandomUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.util.ClassUtils;

@Aspect
@Order(value=-2147483648)
public class CachingAspect {
    private static final Logger log = LoggerFactory.getLogger(CachingAspect.class);
    private final Fetcher fetcher;
    private final Set<String> enable;
    private final RtaClientMicroMeter meter;
    private final Duration hitExpireTime;
    private final Duration unhitExpireTime;

    public CachingAspect(Fetcher fetcher, Set<String> enable, RtaClientMicroMeter meter, Duration hitExpireTime, Duration unhitExpireTime) {
        this.fetcher = fetcher;
        this.enable = enable;
        this.meter = meter;
        this.hitExpireTime = hitExpireTime;
        this.unhitExpireTime = unhitExpireTime;
    }

    @Pointcut(value="this(com.bxm.pangu.rta.common.RtaClient) && execution(boolean isTarget(..))")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(final ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof RtaClient)) {
            return point.proceed();
        }
        final RtaClient client = (RtaClient)target;
        Object[] args = point.getArgs();
        if (ArrayUtils.isEmpty((Object[])args)) {
            return point.proceed();
        }
        Object arg = args[0];
        if (!(arg instanceof RtaRequest)) {
            return point.proceed();
        }
        final RtaRequest request = (RtaRequest)arg;
        if (!this.enable.contains(ClassUtils.getUserClass((Object)client).getName())) {
            return point.proceed();
        }
        this.meter.incrementWithCaching(client.getRtaType());
        ExpireTime expireTime = new ExpireTime();
        return this.fetcher.fetch(new TargetFactory().keyGenerator(new KeyGenerator(){

            public String generateKey() {
                String simple = ToStringBuilder.reflectionToString((Object)request, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
                int type = client.getRtaType().getType();
                String key = KeyBuilder.build((Object[])new Object[]{"RTA", "CACHE", DateHelper.getDate(), type, MurmursUtils.hash(simple)});
                if (log.isDebugEnabled()) {
                    log.debug("{}", (Object)key);
                }
                return key;
            }
        }).cls(Boolean.class).expireTimeInSecond(expireTime.getTime()).dataExtractor((DataExtractor)new DataExtractor<Boolean>(){

            public Boolean extract() {
                try {
                    return (boolean)((Boolean)point.proceed());
                }
                catch (Throwable throwable) {
                    return false;
                }
            }

            public int updateExpireTimeInSecond(Boolean extract, int expireTimeInSecond) {
                try {
                    if (extract.booleanValue()) {
                        return (int)CachingAspect.this.hitExpireTime.getSeconds();
                    }
                    return (int)CachingAspect.this.unhitExpireTime.getSeconds();
                }
                catch (Exception e) {
                    log.warn("Rta Cache time acquisition failed \uff1a", (Throwable)e);
                    return expireTimeInSecond;
                }
            }
        }).build());
    }

    public static class ExpireTime {
        private int time = (int)DateHelper.getRemainSecondsOfToday() + RandomUtils.nextInt((int)3600);

        public int getTime() {
            return this.time;
        }

        public void setTime(int time) {
            this.time = time;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpireTime)) {
                return false;
            }
            ExpireTime other = (ExpireTime)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getTime() == other.getTime();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExpireTime;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTime();
            return result;
        }

        public String toString() {
            return "CachingAspect.ExpireTime(time=" + this.getTime() + ")";
        }
    }
}

