/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.alipay;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.AbstractRtaProperties;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.UUIDHelper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class AlipayRtaClient
extends AbstractHttpClientRtaClient {
    private static final Logger log = LoggerFactory.getLogger(AlipayRtaClient.class);

    public AlipayRtaClient(AbstractRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = request.getParam();
        if (StringUtils.isBlank((String)param)) {
            throw new RtaRequestException("Illegal param value");
        }
        String[] strings = StringUtils.split((String)param, (String)"|");
        String mediaName = strings[0];
        String url = this.getProperties().getUrl();
        url = UriComponentsBuilder.fromUriString((String)url).replacePath("/rta/json/" + mediaName).build().toUriString();
        JSONObject req = new JSONObject();
        req.put("request_id", (Object)UUIDHelper.generate());
        if (strings.length >= 2) {
            String ids = strings[1];
            req.put("rta_id_list", (Object)ids.split(","));
        }
        String uniqueKey = UUIDHelper.generate();
        String deviceType = "";
        String deviceId = "";
        String encryptType = "";
        if (StringUtils.isNotBlank((String)request.getOaid_md5())) {
            deviceType = "OAID";
            encryptType = "MD5";
            deviceId = request.getOaid_md5();
        } else if (StringUtils.isNotBlank((String)request.getOaid())) {
            deviceType = "OAID";
            deviceId = request.getOaid();
        } else if (StringUtils.isNotBlank((String)request.getImei_md5())) {
            deviceType = "IMEI";
            encryptType = "MD5";
            deviceId = request.getImei_md5();
        } else if (StringUtils.isNotBlank((String)request.getImei())) {
            deviceType = "IMEI";
            deviceId = request.getImei();
        } else if (StringUtils.isNotBlank((String)request.getIdfa_md5())) {
            deviceType = "IDFA";
            encryptType = "MD5";
            deviceId = request.getIdfa_md5();
        } else if (StringUtils.isNotBlank((String)request.getIdfa())) {
            deviceType = "IDFA";
            deviceId = request.getIdfa();
        } else if (CollectionUtils.isNotEmpty(request.getCaid_info())) {
            List<RtaRequest.Caid> caidInfo = request.getCaid_info();
            caidInfo.sort((o1, o2) -> {
                int v1 = NumberUtils.toInt((String)o1.getCaid_version());
                int v2 = NumberUtils.toInt((String)o2.getCaid_version());
                return Integer.compare(v2, v1);
            });
            RtaRequest.Caid caid = caidInfo.get(0);
            deviceType = "CAID";
            deviceId = caid.getCaid() + "_" + caid.getCaid_version();
            if (caid.isMd5()) {
                encryptType = "MD5";
            }
        }
        JSONObject info = new JSONObject();
        info.put("encrypt_type", (Object)encryptType);
        info.put("device_id", (Object)deviceId);
        JSONObject device = new JSONObject();
        device.put(deviceType, (Object)info);
        JSONObject devices = new JSONObject();
        devices.put(uniqueKey, (Object)device);
        req.put("devices", (Object)devices);
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity(req.toJSONString(), "UTF-8"));
        post.addHeader("Content-Type", "application/json");
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        boolean required;
        JSONObject response;
        List<String> rtaIds = this.getRtaId(request);
        if (CollectionUtils.isEmpty(rtaIds)) {
            log.warn("rtaIds empty, param = {}", (Object)request.getParam());
            return false;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        Boolean success = jsonObject.getBoolean("success");
        if (success != null && success.booleanValue() && (response = jsonObject.getJSONObject("response")) != null && (required = response.getBoolean("requiredFlow").booleanValue())) {
            if (response.containsKey((Object)"rtaInfoList")) {
                JSONArray rtaInfoList = response.getJSONArray("rtaInfoList");
                for (int i = 0; i < rtaInfoList.size(); ++i) {
                    boolean result;
                    JSONObject account = rtaInfoList.getJSONObject(i);
                    if (!Objects.nonNull(account)) continue;
                    String id = account.getString("accountId");
                    boolean bl = result = StringUtils.isNotBlank((String)id) && rtaIds.contains(id);
                    if (!result) continue;
                    return result;
                }
            } else {
                log.warn("rtaInfoList not exist, response = {}", (Object)json);
            }
        }
        return false;
    }

    private List<String> getRtaId(RtaRequest request) {
        String param = request.getParam();
        if (StringUtils.isEmpty((String)param)) {
            return null;
        }
        String[] array = param.split("\\|");
        if (array.length < 2) {
            return null;
        }
        String rtaIds = array[2];
        if (StringUtils.isEmpty((String)rtaIds)) {
            return null;
        }
        return Lists.newArrayList((Object[])rtaIds.split(","));
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Alipay;
    }
}

