/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.baidu;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.baidu.BaiduRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class BaiduRtaClient
extends AbstractHttpClientRtaClient {
    private static final Logger log = LoggerFactory.getLogger(BaiduRtaClient.class);
    private final BaiduRtaProperties properties;

    public BaiduRtaClient(BaiduRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String idfa;
        String oaidMd5;
        String oaid;
        String imeiMd5;
        String url = this.properties.getUrl();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"version", (Object)"1");
        params.add((Object)"channel", (Object)this.properties.getChannel());
        params.add((Object)"type", (Object)request.getParam());
        params.add((Object)"time", (Object)String.valueOf(System.currentTimeMillis() / 1000L));
        String device = null;
        String imei = request.getImei();
        if (StringUtils.isNotBlank((String)imei)) {
            params.add((Object)"imei", (Object)imei);
            device = imei;
        }
        if (StringUtils.isNotBlank((String)(imeiMd5 = request.getImei_md5()))) {
            params.add((Object)"imei_md5", (Object)imeiMd5);
            device = imeiMd5;
        }
        if (StringUtils.isNotBlank((String)(oaid = request.getOaid()))) {
            params.add((Object)"oaid", (Object)oaid);
            device = oaid;
        }
        if (StringUtils.isNotBlank((String)(oaidMd5 = request.getOaid_md5()))) {
            params.add((Object)"oaid_md5", (Object)oaidMd5);
            device = oaidMd5;
        }
        if (StringUtils.isNotBlank((String)(idfa = request.getIdfa()))) {
            params.add((Object)"idfa", (Object)idfa);
            device = idfa;
        }
        if (StringUtils.isBlank((String)device)) {
            throw new RtaRequestException("The device number is empty\uff01");
        }
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)url).replaceQueryParams((MultiValueMap)params);
        String sign = this.signature((MultiValueMap<String, String>)params);
        uriComponentsBuilder.replaceQueryParam("sign", new Object[]{sign});
        return new HttpGet(uriComponentsBuilder.build().toString());
    }

    private String signature(MultiValueMap<String, String> params) {
        TreeMap treeMap = new TreeMap(params.toSingleValueMap());
        StringBuilder s = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            if (!StringUtils.isNotBlank((String)((String)entry.getValue()))) continue;
            s.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        s.append(this.properties.getToken());
        if (log.isDebugEnabled()) {
            log.debug("source string: {}", (Object)s);
        }
        return DigestUtils.md5Hex((String)s.toString()).toLowerCase();
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return ((BaiduRtaResponse)JsonHelper.convert((String)json, BaiduRtaResponse.class)).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Baidu;
    }

    private static class BaiduRtaResponse {
        private String errno;
        private String msg;
        private String data;

        public boolean isTarget() {
            return StringUtils.equals((String)"1", (String)this.data);
        }

        public String getErrno() {
            return this.errno;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getData() {
            return this.data;
        }

        public void setErrno(String errno) {
            this.errno = errno;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setData(String data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaiduRtaResponse)) {
                return false;
            }
            BaiduRtaResponse other = (BaiduRtaResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$errno = this.getErrno();
            String other$errno = other.getErrno();
            if (this$errno == null ? other$errno != null : !this$errno.equals(other$errno)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BaiduRtaResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $errno = this.getErrno();
            result = result * 59 + ($errno == null ? 43 : $errno.hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "BaiduRtaClient.BaiduRtaResponse(errno=" + this.getErrno() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
        }
    }
}

