/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.bzy;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaClientProperties;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.bzy.BzyRequest;
import com.bxm.pangu.rta.common.bzy.BzyResponse;
import com.bxm.pangu.rta.common.bzy.BzyRtaProperties;
import com.bxm.pangu.rta.common.utils.HttpClientUtils;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UUIDHelper;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BzyRtaClient
implements RtaClient {
    private static final Logger log = LoggerFactory.getLogger(BzyRtaClient.class);
    private final BzyRtaProperties properties;
    private final HttpClient httpClient;

    public BzyRtaClient(BzyRtaProperties properties) {
        this.properties = properties;
        this.httpClient = HttpClientUtils.createHttpClient(properties.getMaxTotal(), properties.getDefaultMaxPerRoute(), properties.getConnectionRequestTimeout(), properties.getConnectTimeout(), properties.getSocketTimeout());
    }

    @Override
    public boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        HttpRequestBase requestBase = null;
        RtaType rtaType = this.getRtaType();
        try {
            requestBase = this.create(request);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)requestBase);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.warn("{} - statusCode: {}", (Object)rtaType, (Object)statusCode);
            }
            String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            boolean bl = this.isTarget(body, feedback);
            return bl;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("{} - {}", (Object)rtaType, (Object)e.getMessage());
            }
            throw new RtaRequestException(e);
        }
        finally {
            if (Objects.nonNull(requestBase) && !requestBase.isAborted()) {
                requestBase.abort();
            }
        }
    }

    private HttpRequestBase create(RtaRequest request) {
        String channel;
        String param = request.getParam();
        if (StringUtils.isBlank((CharSequence)param)) {
            log.warn("bzyRtaWarn param must contain sspid|task_id|channel_id");
            throw new RtaRequestException("param must contain sspid|task_id");
        }
        String[] params = param.split("\\|");
        if (params.length < 2) {
            log.warn("bzyRtaWarn param must contain sspid|task_id|channel_id");
            throw new RtaRequestException("param must contain sspid|task_id");
        }
        BzyRequest.DeviceInfo device = new BzyRequest.DeviceInfo();
        String ua = request.getExt();
        if (StringUtils.isBlank((CharSequence)ua)) {
            ua = "ua_miss";
        }
        device.setUa(ua);
        String imei = request.getImei();
        String oaid = request.getOaid();
        String idfa = request.getIdfa();
        String imei_md5 = request.getImei_md5();
        String oaid_md5 = request.getOaid_md5();
        String idfa_md5 = request.getIdfa_md5();
        if (StringUtils.isNotBlank((CharSequence)imei)) {
            device.setImei(imei);
        } else if (StringUtils.isNotBlank((CharSequence)oaid)) {
            device.setOaid(oaid);
        } else if (StringUtils.isNotBlank((CharSequence)idfa)) {
            device.setIdfa(idfa);
        } else if (StringUtils.isNotBlank((CharSequence)imei_md5)) {
            device.setImei_md5(imei_md5);
        } else if (StringUtils.isNotBlank((CharSequence)oaid_md5)) {
            device.setOaid_md5(oaid_md5);
        } else if (StringUtils.isNotBlank((CharSequence)idfa_md5)) {
            device.setIdfa_md5(idfa_md5);
        } else {
            log.warn("bzyRtaWarn deviceId is empty");
            throw new RtaRequestException("deviceId");
        }
        String sspid = params[0];
        String task_id = params[1];
        BzyRequest.Adslot adslot = new BzyRequest.Adslot();
        adslot.setTask_id(task_id.trim());
        if (params.length > 2 && StringUtils.isNotBlank((CharSequence)(channel = params[2]))) {
            adslot.setChannel_id(channel.trim());
        }
        BzyRequest bzyRequest = new BzyRequest();
        String requestId = UUIDHelper.generate();
        bzyRequest.setRequest_id(requestId);
        bzyRequest.setSspid(sspid.trim());
        bzyRequest.setDevice(device);
        bzyRequest.setAdslot(adslot);
        bzyRequest.setSign(this.sign(sspid, requestId));
        HttpPost post = new HttpPost(this.properties.getUrl());
        post.addHeader("Content-Type", "application/json");
        post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)bzyRequest), StandardCharsets.UTF_8));
        return post;
    }

    private String sign(String sspid, String requestId) {
        return DigestUtils.md5Hex((String)(sspid + this.properties.getToken() + requestId));
    }

    private boolean isTarget(String json, Consumer<Map<Object, Object>> feedback) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return false;
        }
        BzyResponse bzyResponse = (BzyResponse)JsonHelper.convert((String)json, BzyResponse.class);
        if (bzyResponse.getError_code() != 0) {
            return false;
        }
        BzyResponse.Ads ads = bzyResponse.getAds();
        if (ads != null && feedback != null) {
            HashMap res = Maps.newHashMap();
            res.put("deep_link", ads.getDeep_link());
            res.put("h5_url", ads.getH5_url());
            res.put("ad_impression", ads.getAd_impression());
            res.put("ad_click", ads.getAd_click());
            feedback.accept(res);
        }
        return true;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Bzy;
    }

    @Override
    public RtaClientProperties getProperties() {
        return this.properties;
    }
}

