/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.core;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.core.RequestEvent;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.util.EventObject;
import org.apache.commons.lang.ArrayUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=-2147483647)
public class EventAspect {
    private static final Logger log = LoggerFactory.getLogger(EventAspect.class);
    private final EventPark eventPark;

    public EventAspect(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    @Pointcut(value="this(com.bxm.pangu.rta.common.RtaClient) && execution(boolean isTarget(..))")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof RtaClient)) {
            return point.proceed();
        }
        RtaClient client = (RtaClient)target;
        Object[] args = point.getArgs();
        if (ArrayUtils.isEmpty((Object[])args)) {
            return point.proceed();
        }
        Object arg = args[0];
        if (!(arg instanceof RtaRequest)) {
            return point.proceed();
        }
        RtaRequest request = (RtaRequest)arg;
        Object ret = point.proceed();
        this.eventPark.post((EventObject)new RequestEvent(this, client, request, (Boolean)ret));
        return ret;
    }
}

