/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.kwai;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.ProtocolFormat;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.kwai.KwaiApi;
import com.bxm.pangu.rta.common.kwai.KwaiRtaProperties;
import com.bxm.warcar.utils.UUIDHelper;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

public class KwaiRtaClient
extends AbstractHttpClientRtaClient {
    private final KwaiRtaProperties properties;

    @Override
    public ProtocolFormat getProtocolFormat() {
        return ProtocolFormat.Protobuf;
    }

    public KwaiRtaClient(KwaiRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = request.getParam();
        if (StringUtils.isBlank((CharSequence)param)) {
            throw new RtaRequestException("Parameter cannot be empty!");
        }
        KwaiApi.RtaRequest.Device.Builder device = KwaiApi.RtaRequest.Device.newBuilder();
        if (StringUtils.isNotBlank((CharSequence)request.getImei())) {
            device.setImei(request.getImei());
        } else if (StringUtils.isNotBlank((CharSequence)request.getImei_md5())) {
            device.setImeiMd5(request.getImei_md5());
        } else if (StringUtils.isNotBlank((CharSequence)request.getOaid())) {
            device.setOaid(request.getOaid());
        } else if (StringUtils.isNotBlank((CharSequence)request.getOaid_md5())) {
            device.setOaidMd5(request.getOaid_md5());
        } else if (StringUtils.isNotBlank((CharSequence)request.getIdfa())) {
            device.setIdfa(request.getIdfa());
        } else if (StringUtils.isNotBlank((CharSequence)request.getIdfa_md5())) {
            device.setIdfaMd5(request.getIdfa_md5());
        } else {
            return null;
        }
        KwaiApi.RtaRequest.Builder kwaiRtaRequest = KwaiApi.RtaRequest.newBuilder();
        kwaiRtaRequest.setDevice(device.build());
        String requestId = UUIDHelper.generate();
        kwaiRtaRequest.setRequestId(requestId);
        long requestTime = System.currentTimeMillis();
        kwaiRtaRequest.setRequestTime(requestTime);
        kwaiRtaRequest.setChannel(this.properties.getChannel());
        kwaiRtaRequest.setSign(this.sign(requestId, requestTime));
        kwaiRtaRequest.addAllPromotionType(Arrays.asList(param.split("\\|")));
        HttpPost post = new HttpPost(this.properties.getUrl());
        post.addHeader("content-type", "application/x-protobuf");
        post.setEntity((HttpEntity)new ByteArrayEntity(kwaiRtaRequest.build().toByteArray()));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isTarget(RtaRequest request, byte[] bytes) {
        try {
            KwaiApi.RtaResponse response = KwaiApi.RtaResponse.parseFrom(bytes);
            if (response.getStatusCode() != 0 || CollectionUtils.isEmpty(response.getPromotionResultList())) {
                return false;
            }
            HashSet<String> promotionTypes = new HashSet<String>(Arrays.asList(request.getParam().split("\\|")));
            Map<String, Boolean> resultMap = response.getPromotionResultList().stream().collect(Collectors.toMap(KwaiApi.RtaResponse.PromotionResult::getPromotionType, KwaiApi.RtaResponse.PromotionResult::getAccept));
            return promotionTypes.stream().anyMatch(type -> resultMap.getOrDefault(type, false) == true);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RtaRequestException(String.format("parseForm: %s", e.getMessage()));
        }
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Kwai;
    }

    private String sign(String requestId, Long requestTime) {
        return DigestUtils.md5Hex((String)(requestId + requestTime + this.properties.getToken())).toLowerCase();
    }
}

