/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.qczj;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.AbstractRtaProperties;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.util.UriComponentsBuilder;

public class QczjRtaClient
extends AbstractHttpClientRtaClient {
    public QczjRtaClient(AbstractRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String channel = request.getParam();
        if (StringUtils.isBlank((String)channel)) {
            throw new RtaRequestException("channel");
        }
        String id = null;
        String idType = null;
        if (StringUtils.isNotBlank((String)request.getOaid())) {
            id = request.getOaid();
            idType = "OAID";
        } else if (StringUtils.isNotBlank((String)request.getOaid_md5())) {
            id = request.getOaid_md5();
            idType = "OAID_MD5";
        } else if (StringUtils.isNotBlank((String)request.getIdfa())) {
            id = request.getIdfa();
            idType = "IDFA";
        } else if (StringUtils.isNotBlank((String)request.getIdfa_md5())) {
            id = request.getIdfa_md5();
            idType = "IDFA_MD5";
        } else if (StringUtils.isNotBlank((String)request.getImei())) {
            id = request.getImei();
            idType = "IMEI";
        } else if (StringUtils.isNotBlank((String)request.getImei_md5())) {
            id = request.getImei_md5();
            idType = "IMEI_MD5";
        } else if (StringUtils.isNotBlank((String)request.getAndroidid())) {
            id = request.getAndroidid();
            idType = "ANDROID_ID";
        } else if (StringUtils.isNotBlank((String)request.getAndroidid_md5())) {
            id = request.getAndroidid_md5();
            idType = "ANDROID_ID_MD5";
        } else {
            return null;
        }
        String url = UriComponentsBuilder.fromUriString((String)this.getProperties().getUrl()).queryParam("id", new Object[]{id}).queryParam("idType", new Object[]{idType}).queryParam("channel", new Object[]{channel}).build().toString();
        return new HttpGet(url);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return ((Res)JsonHelper.convert((String)json, Res.class)).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Qczj;
    }

    public static class Result {
        private boolean allowed;
        private List<String> materialCodes;

        public boolean isAllowed() {
            return this.allowed;
        }

        public List<String> getMaterialCodes() {
            return this.materialCodes;
        }

        public void setAllowed(boolean allowed) {
            this.allowed = allowed;
        }

        public void setMaterialCodes(List<String> materialCodes) {
            this.materialCodes = materialCodes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAllowed() != other.isAllowed()) {
                return false;
            }
            List<String> this$materialCodes = this.getMaterialCodes();
            List<String> other$materialCodes = other.getMaterialCodes();
            return !(this$materialCodes == null ? other$materialCodes != null : !((Object)this$materialCodes).equals(other$materialCodes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAllowed() ? 79 : 97);
            List<String> $materialCodes = this.getMaterialCodes();
            result = result * 59 + ($materialCodes == null ? 43 : ((Object)$materialCodes).hashCode());
            return result;
        }

        public String toString() {
            return "QczjRtaClient.Result(allowed=" + this.isAllowed() + ", materialCodes=" + this.getMaterialCodes() + ")";
        }
    }

    public static class Res {
        private int returncode = -1;
        private String message;
        private Result result;

        public boolean isTarget() {
            return this.returncode == 0 && Objects.nonNull(this.result) && this.result.isAllowed();
        }

        public int getReturncode() {
            return this.returncode;
        }

        public String getMessage() {
            return this.message;
        }

        public Result getResult() {
            return this.result;
        }

        public void setReturncode(int returncode) {
            this.returncode = returncode;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Res)) {
                return false;
            }
            Res other = (Res)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getReturncode() != other.getReturncode()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Result this$result = this.getResult();
            Result other$result = other.getResult();
            return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Res;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getReturncode();
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Result $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            return result;
        }

        public String toString() {
            return "QczjRtaClient.Res(returncode=" + this.getReturncode() + ", message=" + this.getMessage() + ", result=" + this.getResult() + ")";
        }
    }
}

