/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.qihang;

import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.qihang.enums.CarrierEnum;
import com.bxm.pangu.rta.common.qihang.enums.ConnectionTypeEnum;
import com.bxm.pangu.rta.common.qihang.enums.DeviceTypeEnum;
import com.bxm.pangu.rta.common.qihang.proto.SurgeBidding;
import com.bxm.pangu.rta.common.qihang.request.App;
import com.bxm.pangu.rta.common.qihang.request.BidRequest;
import com.bxm.pangu.rta.common.qihang.request.Device;
import com.bxm.pangu.rta.common.qihang.request.Ext;
import com.bxm.pangu.rta.common.qihang.request.Impression;
import com.bxm.pangu.rta.common.qihang.request.PanGuDevice;
import com.bxm.pangu.rta.common.qihang.request.PanGuImpression;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class QiHangRequestBuilder {
    public static SurgeBidding.BidRequest buildRequest(BidRequest request) {
        SurgeBidding.BidRequest.App app;
        SurgeBidding.BidRequest.Device device;
        String ext = request.getExt();
        Ext convert = (Ext)Optional.ofNullable(JsonHelper.convert((String)ext, Ext.class)).orElse(new Ext());
        SurgeBidding.BidRequest.Builder builder = SurgeBidding.BidRequest.newBuilder();
        builder.setId(request.getBidid());
        builder.setApiVersion("1.0.0");
        if (request.getTest() != null) {
            builder.setTest(0);
        }
        if ((device = StringUtils.isNotBlank((CharSequence)convert.getDevice()) ? QiHangRequestBuilder.buildDevice((Device)JsonHelper.convert((String)convert.getDevice(), Device.class)) : QiHangRequestBuilder.buildDevice(request.getDevice())) != null) {
            builder.setDevice(device);
        }
        if ((app = QiHangRequestBuilder.buildApp(request.getApp())) != null) {
            builder.setApp(app);
        }
        ArrayList imps = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)convert.getImps())) {
            List impressions = JSONObject.parseArray((String)convert.getImps(), Impression.class);
            if (CollectionUtils.isNotEmpty((Collection)impressions)) {
                for (Impression impression : impressions) {
                    SurgeBidding.BidRequest.Imp imp = QiHangRequestBuilder.buildImp(impression);
                    if (imp == null) continue;
                    imps.add(imp);
                }
            }
        } else {
            PanGuImpression imp = request.getImp();
            imps.add(QiHangRequestBuilder.buildImp(imp));
        }
        builder.addAllImp(imps);
        builder.setSspTime(System.currentTimeMillis());
        return builder.build();
    }

    public static SurgeBidding.BidRequest.Device buildDevice(Device device) {
        if (device == null) {
            return null;
        }
        return SurgeBidding.BidRequest.Device.newBuilder().setUa(QiHangRequestBuilder.getValueOrEmpty(device.getUa())).setIp(QiHangRequestBuilder.getValueOrEmpty(device.getIp())).setDeviceType(DeviceTypeEnum.toRequestDeviceType(device.getDevice_type())).setMake(device.getMake() == null ? (device.getBrand() == null ? "" : device.getBrand()) : device.getMake()).setModel(QiHangRequestBuilder.getValueOrEmpty(device.getModel())).setIdfa(QiHangRequestBuilder.getValueOrEmpty(device.getIdfa())).setIdfaMd5(QiHangRequestBuilder.getValueOrEmpty(device.getIdfa_md5())).setOaid(QiHangRequestBuilder.getValueOrEmpty(device.getOaid())).setOaidMd5(QiHangRequestBuilder.getValueOrEmpty(device.getOaid_md5())).setImei(QiHangRequestBuilder.getValueOrEmpty(device.getImei())).setImeiMd5(QiHangRequestBuilder.getValueOrEmpty(device.getImei_md5())).setOs(device.getOs() == null ? "" : device.getOs().toLowerCase()).setOsv(QiHangRequestBuilder.getValueOrEmpty(device.getOsv())).setCarrier(CarrierEnum.toRequestCarrier(device.getCarrier())).setConnectionType(ConnectionTypeEnum.toRequestConnectionType(device.getConnection_type())).setAndroidId(QiHangRequestBuilder.getValueOrEmpty(device.getDpid())).setAndroidIdMd5(QiHangRequestBuilder.getValueOrEmpty(device.getDpid_md5())).setMac(QiHangRequestBuilder.getValueOrEmpty(device.getMac())).setMacMd5(QiHangRequestBuilder.getValueOrEmpty(device.getMac_md5())).build();
    }

    public static SurgeBidding.BidRequest.Device buildDevice(PanGuDevice device) {
        if (device == null) {
            return null;
        }
        return SurgeBidding.BidRequest.Device.newBuilder().setUa(QiHangRequestBuilder.getValueOrEmpty(device.getUa())).setIp(QiHangRequestBuilder.getValueOrEmpty(device.getIp())).setMake(device.getMake() == null ? (device.getBrand() == null ? "" : device.getBrand()) : device.getMake()).setModel(QiHangRequestBuilder.getValueOrEmpty(device.getModel())).setIdfa(QiHangRequestBuilder.getValueOrEmpty(device.getIdfa())).setIdfaMd5(QiHangRequestBuilder.getValueOrEmpty(device.getIdfa_md5())).setOaid(QiHangRequestBuilder.getValueOrEmpty(device.getOaid())).setOaidMd5(QiHangRequestBuilder.getValueOrEmpty(device.getOaid_md5())).setImei(QiHangRequestBuilder.getValueOrEmpty(device.getImei())).setImeiMd5(QiHangRequestBuilder.getValueOrEmpty(device.getImei_md5())).setOs(device.getOs() == null ? "" : device.getOs().toLowerCase()).setOsv(QiHangRequestBuilder.getValueOrEmpty(device.getOsv())).setCarrier(CarrierEnum.toRequestCarrier(device.getCarrier())).setConnectionType(ConnectionTypeEnum.toRequestConnectionType1(device.getConnection_type())).setAndroidId(QiHangRequestBuilder.getValueOrEmpty(device.getAndroidid())).setAndroidIdMd5(QiHangRequestBuilder.getValueOrEmpty(device.getAndroidid_md5())).setMac(QiHangRequestBuilder.getValueOrEmpty(device.getMac())).setMacMd5(QiHangRequestBuilder.getValueOrEmpty(device.getMac_md5())).build();
    }

    private static String getValueOrEmpty(String data) {
        return data == null ? "" : data;
    }

    public static SurgeBidding.BidRequest.Imp buildImp(Impression impression) {
        if (impression == null) {
            return null;
        }
        SurgeBidding.BidRequest.Imp.Builder builder = QiHangRequestBuilder.buildImp(impression.getId(), impression.getBid_floor());
        SurgeBidding.BidRequest.Imp.Asset asset = QiHangRequestBuilder.buildAsset(impression);
        if (asset != null) {
            builder.addAsset(asset);
        }
        return builder.build();
    }

    public static SurgeBidding.BidRequest.Imp buildImp(PanGuImpression impression) {
        if (impression == null) {
            return null;
        }
        SurgeBidding.BidRequest.Imp.Builder builder = QiHangRequestBuilder.buildImp(impression.getId(), impression.getBid_floor());
        SurgeBidding.BidRequest.Imp.Asset asset = QiHangRequestBuilder.buildAsset(impression);
        if (asset != null) {
            builder.addAsset(asset);
        }
        return builder.build();
    }

    public static SurgeBidding.BidRequest.Imp.Builder buildImp(String id, BigDecimal bidFloor) {
        SurgeBidding.BidRequest.Imp.Builder builder = SurgeBidding.BidRequest.Imp.newBuilder();
        builder.setId(QiHangRequestBuilder.getValueOrEmpty(id));
        builder.setTagId("bxm_9_1_gd");
        builder.setSubTagId("bxm_9_1_gd");
        builder.setAdType(2);
        builder.setBidType(0);
        builder.setBidFloor(bidFloor == null ? 0L : bidFloor.longValue());
        return builder;
    }

    public static SurgeBidding.BidRequest.Imp.Asset buildAsset(Impression impression) {
        if (impression.getA_native() == null || StringUtils.isEmpty((CharSequence)impression.getA_native().getTemplate())) {
            return null;
        }
        return QiHangRequestBuilder.buildAsset(impression.getH(), impression.getW());
    }

    public static SurgeBidding.BidRequest.Imp.Asset buildAsset(PanGuImpression impression) {
        return QiHangRequestBuilder.buildAsset(impression.getH(), impression.getW());
    }

    public static SurgeBidding.BidRequest.Imp.Asset buildAsset(Integer h, Integer w) {
        SurgeBidding.BidRequest.Imp.Asset.Builder builder = SurgeBidding.BidRequest.Imp.Asset.newBuilder();
        builder.setTemplateId("bxm_kp_5");
        builder.setHeight(1280);
        builder.setWidth(720);
        return builder.build();
    }

    public static SurgeBidding.BidRequest.App buildApp(App app) {
        if (app == null) {
            return null;
        }
        SurgeBidding.BidRequest.App.Builder builder = SurgeBidding.BidRequest.App.newBuilder();
        if (app.getName() != null) {
            builder.setName(app.getName());
        }
        if (app.getBundle() != null) {
            builder.setBundle("com.kuaishou.nebula");
        }
        if (app.getVer() != null) {
            builder.setVerion(app.getVer());
        }
        return builder.build();
    }
}

