/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.qihang;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaClientProperties;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.qihang.QiHangRequestBuilder;
import com.bxm.pangu.rta.common.qihang.QiHangRtaProperties;
import com.bxm.pangu.rta.common.qihang.proto.SurgeBidding;
import com.bxm.pangu.rta.common.qihang.request.BidRequest;
import com.bxm.pangu.rta.common.utils.HttpClientUtils;
import com.bxm.warcar.utils.JsonHelper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.jsoup.helper.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiHangRtaClient
implements RtaClient {
    private static final Logger log = LoggerFactory.getLogger(QiHangRtaClient.class);
    private final HttpClient httpClient;
    private final QiHangRtaProperties properties;

    public QiHangRtaClient(QiHangRtaProperties properties) {
        this.properties = properties;
        this.httpClient = HttpClientUtils.createHttpClient(properties.getMaxTotal(), properties.getDefaultMaxPerRoute(), properties.getConnectionRequestTimeout(), properties.getConnectTimeout(), properties.getSocketTimeout());
    }

    @Override
    public boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        HttpRequestBase requestBase = null;
        RtaType rtaType = this.getRtaType();
        try {
            boolean isTarget;
            HttpResponse response;
            int statusCode;
            requestBase = this.create(request);
            if (log.isDebugEnabled()) {
                log.debug("request: {}", (Object)requestBase.getURI());
            }
            if ((statusCode = (response = this.httpClient.execute((HttpUriRequest)requestBase)).getStatusLine().getStatusCode()) != 200) {
                log.warn("{} - statusCode: {}", (Object)rtaType, (Object)statusCode);
            }
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            boolean bl = isTarget = this.isTarget(request, bytes, feedback);
            return bl;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("{} - {}", (Object)rtaType, (Object)e.getMessage());
            }
            throw new RtaRequestException(e);
        }
        finally {
            if (Objects.nonNull(requestBase) && !requestBase.isAborted()) {
                requestBase.abort();
            }
        }
    }

    private HttpRequestBase create(RtaRequest request) {
        if (StringUtil.isBlank((String)request.getExt())) {
            return null;
        }
        BidRequest bidreq = (BidRequest)JsonHelper.convert((String)request.getExt(), BidRequest.class);
        SurgeBidding.BidRequest bidRequest = QiHangRequestBuilder.buildRequest(bidreq);
        HttpPost post = new HttpPost(this.properties.getUrl());
        post.setEntity((HttpEntity)new ByteArrayEntity(bidRequest.toByteArray()));
        post.addHeader("Content-Type", "application/x-protobuf;charset=UTF-8");
        return post;
    }

    public boolean isTarget(RtaRequest request, byte[] bytes, Consumer<Map<Object, Object>> feedback) {
        try {
            SurgeBidding.BidResponse qiHangResponse = SurgeBidding.BidResponse.parseFrom(bytes);
            log.info(JsonFormat.printer().print((MessageOrBuilder)qiHangResponse));
            List nurls = qiHangResponse.getSeatBidList().stream().flatMap(seatBid -> seatBid.getBidList().stream()).map(SurgeBidding.BidResponse.Bid::getNurl).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (!nurls.isEmpty() && feedback != null) {
                HashMap<String, Object> res = new HashMap<String, Object>();
                res.put("nurls", nurls);
                long price = qiHangResponse.getSeatBid(0).getBid(0).getPrice();
                res.put("price", price);
                feedback.accept(res);
            }
            return !qiHangResponse.getSeatBidList().isEmpty();
        }
        catch (InvalidProtocolBufferException e) {
            log.error("qiHang buildResponse error:", (Throwable)e);
            return false;
        }
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.QiHangRtb;
    }

    @Override
    public RtaClientProperties getProperties() {
        return this.properties;
    }
}

