/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.qihang.enums;

import com.bxm.pangu.rta.common.qihang.enums.AdxConstants;

public enum ConnectionTypeEnum {
    UNKNOWN(0, "\u672a\u77e5"),
    ETHERNET(1, "\u4ee5\u592a\u7f51"),
    WIFI(2, "WIFI"),
    MOBILE_UNKNOWN(3, "\u79fb\u52a8\u7f51\u7edc\u672a\u77e5"),
    MOBILE_2G(4, "2G\u7f51\u7edc"),
    MOBILE_3G(5, "3G\u7f51\u7edc"),
    MOBILE_4G(6, "4G\u7f51\u7edc"),
    MOBILE_5G(7, "5G\u7f51\u7edc");

    private Integer code;
    private String desc;

    private ConnectionTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer toRequestConnectionType(Integer type) {
        AdxConstants.ConnectionType connectionType = AdxConstants.ConnectionType.getType(type);
        switch (connectionType) {
            case WIFI: {
                return ConnectionTypeEnum.WIFI.code;
            }
            case ETHERNET: {
                return ConnectionTypeEnum.ETHERNET.code;
            }
            case UNKNOW_XG: {
                return ConnectionTypeEnum.MOBILE_UNKNOWN.code;
            }
            case _2G: {
                return ConnectionTypeEnum.MOBILE_2G.code;
            }
            case _3G: {
                return ConnectionTypeEnum.MOBILE_3G.code;
            }
            case _4G: {
                return ConnectionTypeEnum.MOBILE_4G.code;
            }
            case _5G: {
                return ConnectionTypeEnum.MOBILE_5G.code;
            }
        }
        return ConnectionTypeEnum.UNKNOWN.code;
    }

    public static Integer toRequestConnectionType1(Integer type) {
        switch (type) {
            case 1: {
                return ConnectionTypeEnum.WIFI.code;
            }
            case 2: {
                return ConnectionTypeEnum.MOBILE_2G.code;
            }
            case 3: {
                return ConnectionTypeEnum.MOBILE_3G.code;
            }
            case 4: {
                return ConnectionTypeEnum.MOBILE_4G.code;
            }
            case 5: {
                return ConnectionTypeEnum.MOBILE_5G.code;
            }
        }
        return ConnectionTypeEnum.UNKNOWN.code;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

