/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.qihangForRtaApi;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaClientProperties;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.qihang.proto.SurgeBidding;
import com.bxm.pangu.rta.common.qihangForRtaApi.QiHangForApiRequestBuilder;
import com.bxm.pangu.rta.common.qihangForRtaApi.QiHangRtaForApiProperties;
import com.bxm.pangu.rta.common.utils.HttpClientUtils;
import com.bxm.warcar.utils.DateHelper;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@EnableConfigurationProperties(value={QiHangRtaForApiClient.class})
public class QiHangRtaForApiClient
implements RtaClient {
    private static final Logger log = LoggerFactory.getLogger(QiHangRtaForApiClient.class);
    private final QiHangRtaForApiProperties properties;
    private final HttpClient httpClient;

    public QiHangRtaForApiClient(QiHangRtaForApiProperties properties) {
        this.properties = properties;
        this.httpClient = HttpClientUtils.createHttpClient(properties.getMaxTotal(), properties.getDefaultMaxPerRoute(), properties.getConnectionRequestTimeout(), properties.getConnectTimeout(), properties.getSocketTimeout());
    }

    @Override
    public boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        HttpRequestBase requestBase = null;
        RtaType rtaType = this.getRtaType();
        try {
            requestBase = this.create(request);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)requestBase);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.warn("{} - statusCode: {}", (Object)rtaType, (Object)statusCode);
            }
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            boolean bl = this.isTarget(request, bytes, feedback);
            return bl;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("{} - {}", (Object)rtaType, (Object)e.getMessage());
            }
            throw new RtaRequestException(e);
        }
        finally {
            if (Objects.nonNull(requestBase) && !requestBase.isAborted()) {
                requestBase.abort();
            }
        }
    }

    private HttpRequestBase create(RtaRequest request) {
        SurgeBidding.BidRequest bidRequest = QiHangForApiRequestBuilder.buildRequest(request);
        HttpPost post = new HttpPost(this.properties.getUrl());
        post.setEntity((HttpEntity)new ByteArrayEntity(bidRequest.toByteArray()));
        post.addHeader("Content-Type", "application/x-protobuf;charset=UTF-8");
        return post;
    }

    public boolean isTarget(RtaRequest request, byte[] bytes, Consumer<Map<Object, Object>> feedback) {
        try {
            SurgeBidding.BidResponse qiHangResponse = SurgeBidding.BidResponse.parseFrom(bytes);
            List nurls = qiHangResponse.getSeatBidList().stream().flatMap(seatBid -> seatBid.getBidList().stream()).map(SurgeBidding.BidResponse.Bid::getNurl).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (!nurls.isEmpty() && feedback != null) {
                HashMap<String, Object> res = new HashMap<String, Object>();
                res.put("nurls", nurls);
                long price = qiHangResponse.getSeatBid(0).getBid(0).getPrice();
                res.put("price", price);
                if (Math.random() < 0.1) {
                    log.info("qiHangPrice id : {} - bidId : {} - price : {} - time : {}", new Object[]{qiHangResponse.getId(), qiHangResponse.getBidId(), price, DateHelper.format((String)"yyyy-MM-dd HH:mm:ss")});
                }
                feedback.accept(res);
            }
            return !qiHangResponse.getSeatBidList().isEmpty();
        }
        catch (InvalidProtocolBufferException e) {
            log.error("qiHang buildResponse error:", (Throwable)e);
            return false;
        }
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.QiHangRtbForApi;
    }

    @Override
    public RtaClientProperties getProperties() {
        return this.properties;
    }
}

