/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.qihangForRtaApi.enums;

import com.bxm.pangu.rta.common.qihangForRtaApi.enums.AdxConstants;

public enum CarrierEnum {
    UNKNOWN(0, "\u672a\u77e5"),
    MOBILE(1, "\u79fb\u52a8"),
    UNICOM(2, "\u8054\u901a"),
    TELECOM(3, "\u7535\u4fe1");

    private Integer code;
    private String desc;

    private CarrierEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer toRequestCarrier(Integer type) {
        AdxConstants.Carrier carrier = AdxConstants.Carrier.getCarrier(type);
        switch (carrier) {
            case TELECOM: {
                return CarrierEnum.TELECOM.code;
            }
            case MOBILE: {
                return CarrierEnum.MOBILE.code;
            }
            case UNICOM: {
                return CarrierEnum.UNICOM.code;
            }
        }
        return CarrierEnum.UNKNOWN.code;
    }

    public static Integer toRequestCarrier(Long type) {
        if (type == 46003L) {
            return CarrierEnum.TELECOM.code;
        }
        if (type == 46000L) {
            return CarrierEnum.MOBILE.code;
        }
        if (type == 46001L) {
            return CarrierEnum.UNICOM.code;
        }
        return CarrierEnum.UNKNOWN.code;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

