/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.tianyancha;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.tianyancha.TianYanChaRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

public class TianYanChaRtaClient
extends AbstractHttpClientRtaClient {
    private static final String IOS = "ios";
    private static final String ANDROID = "android";
    private static final String OTHERS = "others";

    public TianYanChaRtaClient(TianYanChaRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = request.getParam();
        String[] arr = StringUtils.split((String)param, (String)"|");
        if (ArrayUtils.getLength((Object)arr) < 3) {
            throw new RtaRequestException("param");
        }
        String reqId = arr[0];
        String campaignId = arr[1];
        String secretKey = arr[2];
        Request req = new Request();
        req.setReq_id(reqId);
        req.setReq_time(System.currentTimeMillis() / 1000L);
        req.setCampaign_id(campaignId);
        ArrayList users = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)request.getImei())) {
            users.add(new User().setOs_type(ANDROID).setDevice_id(request.getImei()));
        }
        if (StringUtils.isNotBlank((String)request.getImei_md5())) {
            users.add(new User().setOs_type(ANDROID).setDevice_id(request.getImei_md5()));
        }
        if (StringUtils.isNotBlank((String)request.getOaid_md5())) {
            users.add(new User().setOs_type(OTHERS).setDevice_id(request.getOaid_md5()));
        }
        if (StringUtils.isNotBlank((String)request.getIdfa_md5())) {
            users.add(new User().setOs_type(IOS).setDevice_id(request.getIdfa_md5()));
        }
        req.setUsers(users);
        String unstr = req.getReq_id() + req.getReq_time() + req.getCampaign_id();
        byte[] unbyte = StringHelper.convert((String)unstr);
        byte[] hmac = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, StringHelper.convert((String)secretKey)).hmac(unbyte);
        String signature = Base64.encodeBase64String((byte[])hmac);
        req.setSignature(signature);
        HttpPost post = new HttpPost(this.getProperties().getUrl());
        post.setEntity((HttpEntity)new ByteArrayEntity(JsonHelper.convert2bytes((Object)req)));
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return ((Response)JsonHelper.convert((String)json, Response.class)).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.TianYanCha;
    }

    private static class Material {
        private String device_id;

        public String getDevice_id() {
            return this.device_id;
        }

        public void setDevice_id(String device_id) {
            this.device_id = device_id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Material)) {
                return false;
            }
            Material other = (Material)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$device_id = this.getDevice_id();
            String other$device_id = other.getDevice_id();
            return !(this$device_id == null ? other$device_id != null : !this$device_id.equals(other$device_id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Material;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $device_id = this.getDevice_id();
            result = result * 59 + ($device_id == null ? 43 : $device_id.hashCode());
            return result;
        }

        public String toString() {
            return "TianYanChaRtaClient.Material(device_id=" + this.getDevice_id() + ")";
        }
    }

    private static class Response {
        private long rsp_time;
        private String result_code;
        private String result_message;
        private List<Material> materials;

        private boolean isTarget() {
            return StringUtils.equalsIgnoreCase((String)"0", (String)this.getResult_code()) && CollectionUtils.isNotEmpty(this.getMaterials());
        }

        public long getRsp_time() {
            return this.rsp_time;
        }

        public String getResult_code() {
            return this.result_code;
        }

        public String getResult_message() {
            return this.result_message;
        }

        public List<Material> getMaterials() {
            return this.materials;
        }

        public void setRsp_time(long rsp_time) {
            this.rsp_time = rsp_time;
        }

        public void setResult_code(String result_code) {
            this.result_code = result_code;
        }

        public void setResult_message(String result_message) {
            this.result_message = result_message;
        }

        public void setMaterials(List<Material> materials) {
            this.materials = materials;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRsp_time() != other.getRsp_time()) {
                return false;
            }
            String this$result_code = this.getResult_code();
            String other$result_code = other.getResult_code();
            if (this$result_code == null ? other$result_code != null : !this$result_code.equals(other$result_code)) {
                return false;
            }
            String this$result_message = this.getResult_message();
            String other$result_message = other.getResult_message();
            if (this$result_message == null ? other$result_message != null : !this$result_message.equals(other$result_message)) {
                return false;
            }
            List<Material> this$materials = this.getMaterials();
            List<Material> other$materials = other.getMaterials();
            return !(this$materials == null ? other$materials != null : !((Object)this$materials).equals(other$materials));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $rsp_time = this.getRsp_time();
            result = result * 59 + (int)($rsp_time >>> 32 ^ $rsp_time);
            String $result_code = this.getResult_code();
            result = result * 59 + ($result_code == null ? 43 : $result_code.hashCode());
            String $result_message = this.getResult_message();
            result = result * 59 + ($result_message == null ? 43 : $result_message.hashCode());
            List<Material> $materials = this.getMaterials();
            result = result * 59 + ($materials == null ? 43 : ((Object)$materials).hashCode());
            return result;
        }

        public String toString() {
            return "TianYanChaRtaClient.Response(rsp_time=" + this.getRsp_time() + ", result_code=" + this.getResult_code() + ", result_message=" + this.getResult_message() + ", materials=" + this.getMaterials() + ")";
        }
    }

    private static class User {
        private String os_type;
        private String device_id;

        public String getOs_type() {
            return this.os_type;
        }

        public String getDevice_id() {
            return this.device_id;
        }

        public User setOs_type(String os_type) {
            this.os_type = os_type;
            return this;
        }

        public User setDevice_id(String device_id) {
            this.device_id = device_id;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof User)) {
                return false;
            }
            User other = (User)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$os_type = this.getOs_type();
            String other$os_type = other.getOs_type();
            if (this$os_type == null ? other$os_type != null : !this$os_type.equals(other$os_type)) {
                return false;
            }
            String this$device_id = this.getDevice_id();
            String other$device_id = other.getDevice_id();
            return !(this$device_id == null ? other$device_id != null : !this$device_id.equals(other$device_id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof User;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $os_type = this.getOs_type();
            result = result * 59 + ($os_type == null ? 43 : $os_type.hashCode());
            String $device_id = this.getDevice_id();
            result = result * 59 + ($device_id == null ? 43 : $device_id.hashCode());
            return result;
        }

        public String toString() {
            return "TianYanChaRtaClient.User(os_type=" + this.getOs_type() + ", device_id=" + this.getDevice_id() + ")";
        }
    }

    private static class Request {
        private String req_id;
        private List<User> users;
        private long req_time;
        private String campaign_id;
        private String signature;

        public String getReq_id() {
            return this.req_id;
        }

        public List<User> getUsers() {
            return this.users;
        }

        public long getReq_time() {
            return this.req_time;
        }

        public String getCampaign_id() {
            return this.campaign_id;
        }

        public String getSignature() {
            return this.signature;
        }

        public void setReq_id(String req_id) {
            this.req_id = req_id;
        }

        public void setUsers(List<User> users) {
            this.users = users;
        }

        public void setReq_time(long req_time) {
            this.req_time = req_time;
        }

        public void setCampaign_id(String campaign_id) {
            this.campaign_id = campaign_id;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getReq_time() != other.getReq_time()) {
                return false;
            }
            String this$req_id = this.getReq_id();
            String other$req_id = other.getReq_id();
            if (this$req_id == null ? other$req_id != null : !this$req_id.equals(other$req_id)) {
                return false;
            }
            List<User> this$users = this.getUsers();
            List<User> other$users = other.getUsers();
            if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
                return false;
            }
            String this$campaign_id = this.getCampaign_id();
            String other$campaign_id = other.getCampaign_id();
            if (this$campaign_id == null ? other$campaign_id != null : !this$campaign_id.equals(other$campaign_id)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $req_time = this.getReq_time();
            result = result * 59 + (int)($req_time >>> 32 ^ $req_time);
            String $req_id = this.getReq_id();
            result = result * 59 + ($req_id == null ? 43 : $req_id.hashCode());
            List<User> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            String $campaign_id = this.getCampaign_id();
            result = result * 59 + ($campaign_id == null ? 43 : $campaign_id.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            return result;
        }

        public String toString() {
            return "TianYanChaRtaClient.Request(req_id=" + this.getReq_id() + ", users=" + this.getUsers() + ", req_time=" + this.getReq_time() + ", campaign_id=" + this.getCampaign_id() + ", signature=" + this.getSignature() + ")";
        }
    }
}

